'use strict';

//Globals
var GSelectedDirStr = "";
var GCurrentProfileAction = "";

var GProfileEditorInitialized=false;

var GInternetProtocolSetLEFTRegistryList = new Array();
var GInternetProtocolSetRIGHTRegistryList = new Array();
var GInternetProtocolSetADDDESTRegistryList = new Array();

// Real-Time settings Dialog
var GRunCompletelyOnceCb = false;
var GRealtimeFolderMode = false;
var GRealTimeDeletions = false;
var GRealTimeDeletionsSafetyDelay = 0;
var GRealTimeRenames = false;
var GRealTimeIgnoreTempFiles = false;
var GRealtimeDelaySeconds = 0;
var GFullRunBasedOnItemCount = 0;
var GFullRunBasedOnTimeSeconds = 0;

var GNewProfileName;

// new in V9
var GRealtimeCheckFTPForChanges = false;
var GUseFTPChangesTechniqueForLeftSide = false;
var GUseFTPChangesTechniqueForRightSide = false;
var GFTPChangesCheckIntervalSeconds = 0;

// Tab Files->Deletion ->FoldersForDeletedFiles Dlg
var GMoveDeletedFilesIntoFolderL = "";
var GMoveDeletedFilesIntoFolderR = "";

var GInternetSettingsListloaded = false;

// Tab Special
var HTML_CacheDestinationFileListDlg = "";
var GSpecial_DoubleCheckCacheHoles = false;
var GSpecial_RefreshCacheEvery = 0;
var GSpecial_CacheNotRefreshedCounter = 0;

var HTML_PascalScriptDlg =
'<div id="jqxPascalScriptDlg">'+
'<div>PascalScript</div>'+
'<div> '+
'<table align="left" style="margin: 0px auto;">'+
'<tr>'+
'  <td valign="top">'+
'   <br>'+
'     <div class="info-box"><p>Enter the PascalScript for this profile here.<br><br>'+
'Please see <a HREF="https://www.syncovery.com/pascalscript/" target="_blank">the PascalScript documentation</a> on our web site for more information.</p></div><br>'+
'     <textarea style="margin-left: 10px;" id="inptPascalScript"></textarea><br><br>'+
'  </td>'+
'</tr>'+
'</table>'+
'<div class="jqx-window-footer-float">'+
'<button id="PascalScript_OK_btn">OK</button>'+
'<button id="PascalScript_Cancel_btn">Cancel</button>'+
'</div>'+
'</div>'+
'</div>';

var HTML_KeyDlg =
'<div id="jqxKeyDlg">'+
'<div>Key</div>'+
'<div> '+
'<table align="left" style="margin: 0px auto;">'+
'<tr>'+
'  <td valign="top">'+
'   <br>'+
'     <div class="info-box"><p>Enter the required PGP key here.<br><br>'+
'Please see <a HREF="https://www.syncovery.com/documentation/faq/automatic-pgp-file-exchange/" target="_blank">the PGP documentation</a> on our web site for more information.</p></div><br>'+
'     <textarea style="margin-left: 10px;" id="inptKey"></textarea><br><br>'+
'  </td>'+
'</tr>'+
'</table>'+
'<div class="jqx-window-footer-float">'+
'<button id="Key_OK_btn">OK</button>'+
'<button id="Key_Cancel_btn">Cancel</button>'+
'</div>'+
'</div>'+
'</div>';


function DeleteLoadedProfile()
{
  var sendparams = { };

  sendparams.ProfileName = GLoadedProfile;
  sendparams.RenamedTo = GNewProfileName;
  sendparams.token = GClientToken;
  var json = JSON.stringify(sendparams);
  $.post("post_deleteprofile.php", json).done(function(data)
  {
      if (data == 'Deleted' )
      {
         RefreshMainGrid();
      }
      else
      {
         alert("profile '" + SelectedProfile + "' could not be deleted: "+data);
      }
  });
}


function AskIfKeepBothProfiles()
{
  showConfirmationDialog("Please confirm",
                         "The profile name was changed. Would you like to also keep the previous version of the profile under the old name?",
                         false,
                         function (choice) {
                           if (choice=="No")
                              DeleteLoadedProfile();
                         });
}
      
var GCurrentLeftRightEdit = null;
var GCurrentLeftRightRawURL = "";
var GProtocolName = "";
var GCurrentUsername = "";
var GCurrentPassword = "";

function DoInternetSettingsDialog( ProfileName, InternetProtocolRegistryList, LeftOrRight,
                                   ProtocolName, LeftRightEdit,
                                   LeftRightRawURL,
                                   AUsername,APassword,
                                   DefaultSMB,
                                   WindowToFocusOnClose )
{
   GProtocolName = ProtocolName;
     if ((GProtocolName==undefined) || (GProtocolName=="") || (GetBaseProtocolName(GProtocolName)==''))
        if (DefaultSMB)
           GProtocolName = "SMB";
        else
           GProtocolName = "FTP";
    GCurrentList = InternetProtocolRegistryList;
    GCurrentLeftRightEdit = LeftRightEdit;
    GCurrentLeftRightRawURL = LeftRightRawURL;
    GCurrentUsername = AUsername;
    GCurrentPassword = APassword;
    if (!GCurrentList[indexOfListLoaded].ListLoaded)
    {
   //    GCurrentList = deepCopy( GInternetProtocolSetRegistryList );  //GInternetProtocolSetRegistryList.slice();//

        if (!ProfileName || (ProfileName=="") || (LeftOrRight=="adddest"))
        {
           GCurrentLeftRightRawURL = "";
           LoadDefaultsToRegistryList( GCurrentList, true );
           if (LeftOrRight=="adddest")
           {
              // alert("Loading GAddDestFTPSettings: "+ JSON.stringify(GAddDestFTPSettings));
              LoadRecordToRegistryList(GAddDestFTPSettings,GCurrentList,GetBaseProtocolName(GProtocolName));
           }
           InitProtocolSettingsForm( ProfileName, GCurrentList, LeftOrRight, GProtocolName, GCurrentLeftRightEdit, GCurrentLeftRightRawURL, WindowToFocusOnClose);
           GCurrentList[indexOfListLoaded].ListLoaded = true;

           // **** DEFAULT TIMEOUT AND RETRIES FROM GLOBAL VARS ****

           if ($('#adv_timeout').length)
              $('#adv_timeout').jqxFormattedInput('val',GIPTimeout);
           if ($('#adv_retries').length)
              $('#adv_retries').jqxFormattedInput('val',GIPRetries);

           // OTHER GLOBALS TOO?
           //- GDOCS
         }
        else
        {
          // normal case when editing a profile
          InitProtocolSettingsDatasource( GIntProtSetSource, ProfileName, LeftOrRight, GProtocolName);

          var IntProtSetDataAdapter = new $.jqx.dataAdapter(GIntProtSetSource,

          { loadComplete: function ()
              {
                // get data records.
                if (IntProtSetDataAdapter.xhr.responseText == '{"error":"session_timeout"}' )
                {
                   window.location = '/index.html';
                   return;
                }
                else if ( IntProtSetDataAdapter.xhr.responseText == '{"error":"session_busy"}' )
                {
                   window.location = '/post_session_busy.php';
                   return;
                }

                if (IntProtSetDataAdapter.records.length == 1)
                {
                  var record = IntProtSetDataAdapter.records[0];
                  LoadRecordToRegistryList(record, GCurrentList, GetBaseProtocolName(GProtocolName));
                }
                else
                {
                  //alert('Protocol ' + GProtocolName + ' is not supported in Web Interface yet. Sorry.');
                  //GProtocolName = "FTP";
                  GCurrentLeftRightRawURL = "";
                  LoadDefaultsToRegistryList( GCurrentList, true );
                }
                InitProtocolSettingsForm( ProfileName, GCurrentList, LeftOrRight, GProtocolName, GCurrentLeftRightEdit, GCurrentLeftRightRawURL, WindowToFocusOnClose);
                GCurrentList[indexOfListLoaded].ListLoaded = true;

              }
              ,
              loadError: function (jqXHR, status, error) {

                  if (error == "")
                    alert("Error. Connection with server might be lost.");
                  else
                    alert(error);

               }
           });

           IntProtSetDataAdapter.dataBind();
        }
     }
     else 
       InitProtocolSettingsForm( ProfileName, GCurrentList, LeftOrRight, GProtocolName, GCurrentLeftRightEdit, GCurrentLeftRightRawURL, WindowToFocusOnClose);
}

function DoSMBDialog(ProfileName,RightSide,inputField,StoredPath)
{
  if (RightSide)
     DoInternetSettingsDialog(ProfileName,
                              GInternetProtocolSetRIGHTRegistryList,
                              "right",
                              GRightProtocolName,
                              inputField,
                              StoredPath,
                              GRightUsername,
                              GRightPassword,
                              true, // default to SMB
                              $('#jqxProfileEditorForm'));
  else
     DoInternetSettingsDialog(ProfileName,
                              GInternetProtocolSetLEFTRegistryList,
                              "left",
                              GLeftProtocolName,
                              inputField,
                              StoredPath,
                              GLeftUsername,
                              GLeftPassword,
                              true, // default to SMB
                              $('#jqxProfileEditorForm'));
 }

function ShowPascalScriptDlg(event)
{
  if ($("#jqxPascalScriptCb").jqxCheckBox( 'disabled'))
     return;

  if (!GAllowPascalScript)
  {
     alert('PascalScript is not supported on this CPU type.');
     $("#jqxPascalScriptCb").jqxCheckBox( 'val',  GUsePascalScript );
     return;
  }

  $("#HTML_PascalScriptDlg_div").html( HTML_PascalScriptDlg );
  $('#jqxPascalScriptDlg').jqxWindow({ maxWidth: 10000,  width: 800, maxHeight:10000, height:700,
                                       autoOpen: false, isModal: true,
                                       theme: GTheme, animationType: 'slide',
                                       draggable: true });

  $("#inptPascalScript").jqxInput({ width: 720, height: 500});
  if (GUsePascalScript)
     $("#inptPascalScript").jqxInput('val', GPascalScript);
  else
     $("#inptPascalScript").jqxInput('val','');

  $('#PascalScript_OK_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
  $('#PascalScript_OK_btn').off('click');
  $('#PascalScript_OK_btn').click(function ()
  {

     GPascalScript = $("#inptPascalScript").jqxInput('val');
     GUsePascalScript = (GPascalScript!='');
     $('#jqxPascalScriptDlg').jqxWindow('close');

  });

  $('#PascalScript_Cancel_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
  $('#PascalScript_Cancel_btn').off('click');
  $('#PascalScript_Cancel_btn').click(function () {
      $('#jqxPascalScriptDlg').jqxWindow('close');
  });

  $('#jqxPascalScriptDlg').on('close',
      function (event)
      {
        $("#jqxPascalScriptCb").jqxCheckBox( 'val',  GUsePascalScript );
      });

  $('#jqxPascalScriptDlg').jqxWindow('open');

};

function ShowProfileDetails()
{
  alert("Please note: the following page will show the saved profile settings. Changes you just made in the dialog will not be taken into account.\n\n"+
        "We will now try to open a new tab or window.");
  window.open('post_profileinfo.php?token='+GClientToken+'&profile='+encodeURIComponent(GSelectedProfileName));
}

function ShowKeyDlg(initialvalue,isPrivateKey)
{
  $("#HTML_KeyDlg_div").html( HTML_KeyDlg );
  $('#jqxKeyDlg').jqxWindow({ maxWidth: 10000,  width: 800, maxHeight:10000, height:700,
                                       autoOpen: false, isModal: true,
                                       theme: GTheme, animationType: 'slide',
                                       draggable: true });

  $("#inptKey").jqxInput({ width: 720, height: 500});
  $("#inptKey").jqxInput('val', initialvalue);

  $('#Key_OK_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
  $('#Key_OK_btn').off('click');
  $('#Key_OK_btn').click(function ()
  {
     if (isPrivateKey)
        GPGPPrivateKey = $("#inptKey").jqxInput('val');
     else
        GPGPPublicKey = $("#inptKey").jqxInput('val');
     $('#jqxKeyDlg').jqxWindow('close');
  });

  $('#Key_Cancel_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
  $('#Key_Cancel_btn').off('click');
  $('#Key_Cancel_btn').click(function () {
      $('#jqxKeyDlg').jqxWindow('close');
  });

  $('#jqxKeyDlg').jqxWindow('open');
};

function InitProfileEditorForm( ProfileName, CurrentProfileAction )
{
 showstatusmessage("Initializing Editor Form");
 try
 {
   GSelectedProfileName = ProfileName;
   GCurrentProfileAction = CurrentProfileAction;

   // now in synappglobals.js
   // GetHTMLintoVar('SmartTrackingSettingsDlg.html', 'HTML_SmartTrackingSettingsDlg');
   // GetHTMLintoVar('ExactMirrorSettingsDlg.html', 'HTML_ExactMirrorSettingsDlg');
   // GetHTMLintoVar('MoveSettingsDlg.html', 'HTML_MoveSettingsDlg');

   $("#ProfileEditorForm_div").html(ProfileEditorFormHTML);

   // Tab Control
   var bMainSettingsTabCreated = false;
   var bFoldersTabCreated = false;
   var bJobTabCreated = false;
   var bTabInformationCreated = false;
   var bScheduleTabCreated = false;
   var bScheduleMoreTabCreated = false;
   var bScheduleWeekdaysTabCreated = false;
   var bSheduleMonitoringTabCreated = false;
   var bTabsAccessAndRetriesCreated = false;
   var bTabErrorsCreated = false;
   var bTabRetriesCreated = false;
   var bTabFilesMore = false;
   var bTabFileAccess = false;
   var bTabsMasks = false;
   var bTabsMasksExclusionMasks = false;
   var bTabsFilters = false;
   var bTabsFiltersFileAge = false;
   var bTabsSafety = false;
   var bTabsSafetySafety = false;
   var bTabsSafetyUnattended = false;

   var bTabsSpecialDatabase = false;
   var bTabsVersioning = false;
   var bTabsVerification = false;
   var bTabsVersioningSynthetic = false;
   var bTabsVersioningMore =  false;
   var bTabsZip = false;
   var bTabsEncryption = false;
   var bTabsInfo = false;

   // some of them are global variables, which need to be initialized every time
   GbTabsComparisonCreated = false;
   GbTabsComparisonMoreCreated = false;
   GbTabFiles = false;
   GbTabFilesDeletions = false;
   GbTabBlockLevelCopying = false;
   Gb_TabSpecial = false;
   GTabMasksGeneralFilters = false;
   GTabMasksFileAge = false;

   // init advanced settings categories menu
   var menuItems = [
     { label: "Main Settings", value: "main",  image: "images/icons/home.png" },
     { label: "Schedule",      value: "sched", image: "images/icons/clock.png" },
     { label: "Comparison",    value: "comp",   image: "images/icons/compare.png" },
     { label: "Files",         value: "files", image: "images/icons/files.png" },
     { label: "Folders",       value: "folders",  image: "images/icons/folder.png" },
     { label: "Job",           value: "job",   image: "images/icons/job.png" },
     { label: "Masks",         value: "masks", image: "images/icons/masks.png" },
     { label: "Filters",       value: "filters",  image: "images/icons/filters.png" },
     { label: "Retries",       value: "retries", image: "images/icons/retry.png" },
     { label: "Safety",        value: "safety",  image: "images/icons/shield.png" },
     { label: "Special",       value: "special",  image: "images/icons/star.png" },
     { label: "Verification",  value: "verification",  image: "images/icons/check.png" },
     { label: "Versioning",    value: "versioning",  image: "images/icons/versioning.png" },
     { label: "Compression",   value: "compression",  image: "images/icons/compress.png" },
     { label: "Encryption",    value: "encryption",   image: "images/icons/lock.png" },
     { label: "Error Handling",value: "errors", image: "images/icons/warning.png" },
     { label: "Information",   value: "info",  image: "images/icons/info.png" }
   ];

   $("#menuListBox").jqxListBox({
     source: menuItems,
     displayMember: "label",
     valueMember: "value",
     height: GProfileSettingsMenuHeight,
     itemHeight: 23,
     width: 150,
     selectedIndex: 0,
     // horizontalScrollBarEnabled: false,
     renderer: function (index, label, value) {
       const item = menuItems[index];
       return `<div style="display: flex; align-items: center;">
                 <img src="${item.image}" width="16" height="16" style="margin-left: 6px; margin-right: 6px;">
                 <span>${label}</span>
               </div>`;
     }
   });

   // handle selection
   $('#menuListBox').on('select', function (event)
   {
     var selectedIndex= event.args.index;

     $('#jqxMainCategoryTabs').jqxTabs('select', selectedIndex);
   });


   // initTabContent: initWidgets
   $('#jqxMainCategoryTabs').jqxTabs({ width: GProfileSettingsTabControlWidth, height: GProfileSettingsTabControlHeight,
       theme: GTheme, keyboardNavigation: false,
       initTabContent:
   // var initWidgets =
   function(tab)
   {
       var CategoryName=menuItems[tab].value;

       // alert("Preparing "+CategoryName);

       switch (CategoryName)
       {
         case "main":
           break;

         case "sched":
           $('#jqxTabsSchedule').jqxTabs({ width: GInnerTabControlWidth, height: GInnerTabControlHeight, keyboardNavigation: false });
           //alert('Tab Schedule');
           if (bScheduleTabCreated == false)
           {
             LoadRegistryItemToControlByName('jqxScheduleThisProfileCb');
             LoadRegistryItemToControlByName('jqxRun_Every_Day_Time_Input');
             $("#Run_Every_Day_Radio_Mode").jqxRadioButton({});
             $("#Repeat_after_Radio_Mode").jqxRadioButton({});
             $("#Repeat_monthly_Radio_Mode").jqxRadioButton({});
             $("#Run_only_Once_Radio_Mode").jqxRadioButton({});
             LoadRegistryItemToControlByName('RunModeRadiogroupWidget');

             LoadRegistryItemToControlByName('inptScheduleDays');
             LoadRegistryItemToControlByName('inptScheduleHours');
             LoadRegistryItemToControlByName('inptScheduleMinutes');
             LoadRegistryItemToControlByName('inptScheduleSec');


             LoadRegistryItemToControlByName('jqxSpecifyNextRunCb');
             LoadRegistryItemToControlByName('jqxIntervalSpecificationCb');
             LoadRegistryItemToControlByName('jqxNextRunDay_Input');
             LoadRegistryItemToControlByName('jqxNextRunTime_Input');
                          
             bScheduleTabCreated = true;
           }
           $('#jqxTabsSchedule').on('selecting', function (event)
           { // Some code here.
              var ItemIndex = event.args.item;
              if (ItemIndex == 0)
              {
               ////Schedule
                  //initialized above
              }
              else if ((ItemIndex == 1) && (bScheduleMoreTabCreated == false))
              {
                 ////Schedule More
                 if (GisSyncoveryWindows)
                    LoadRegistryItemToControlByName('jqxScheduleRunUponLogOutCb');
                 else
                 {
                    $('#jqxScheduleRunUponWinLoginCb').html("Run Upon Scheduler Start (System Boot)");
                    $('#jqxScheduleRunUponLogOutCb').css({"display":"none"});
                    $('#ScheduleMoreInfoBox').html("<p>This tab sheet contains additional options for scheduling.<br><br>The 'Run Upon' options may not be applicable to this platform.</p>");
                 }
                 LoadRegistryItemToControlByName('jqxScheduleRunUponWinLoginCb');
                 LoadRegistryItemToControlByName('jqxScheduleRunUponShutdownOrRebootCb');

                 LoadRegistryItemToControlByName('jqxScheduleRunMissedDaylyJobCb');
                 LoadRegistryItemToControlByName('jqxScheduleAddRandomDelayUpToCb');
                 LoadRegistryItemToControlByName('jqxAddRandomDelay_Time_Input');
                 LoadRegistryItemToControlByName('jqxScheduleWarnIfProfileNotRunForCb');
                 LoadRegistryItemToControlByName('jqxWarnIfProfileNotRunFor_Time_Input');

                 LoadRegistryItemToControlByName('jqxUseAdditionalTimes1Cb');
                 LoadRegistryItemToControlByName('jqxAdditionalTimes_Time_Input1');
                 LoadRegistryItemToControlByName('jqxUseAdditionalTimes2Cb');
                 LoadRegistryItemToControlByName('jqxAdditionalTimes_Time_Input2');
                 LoadRegistryItemToControlByName('jqxUseAdditionalTimes3Cb');
                 LoadRegistryItemToControlByName('jqxAdditionalTimes_Time_Input3');
                 LoadRegistryItemToControlByName('jqxUseAdditionalTimes4Cb');
                 LoadRegistryItemToControlByName('jqxAdditionalTimes_Time_Input4');
                 bScheduleMoreTabCreated = true;
                              
              }
              else if ((ItemIndex == 2) && (bScheduleWeekdaysTabCreated == false))
              {

                //Schedule weekdays

                 LoadRegistryItemToControlByName('jqxMondayCb');
                 LoadRegistryItemToControlByName('jqxTuesdayCb');
                 LoadRegistryItemToControlByName('jqxWednesdayCb');
                 LoadRegistryItemToControlByName('jqxThursdayCb');
                 LoadRegistryItemToControlByName('jqxFridayCb');
                 LoadRegistryItemToControlByName('jqxSaturdayCb');
                 LoadRegistryItemToControlByName('jqxSundayCb');
                 LoadRegistryItemToControlByName('jqxRunOnlyBetweenCb');
                 LoadRegistryItemToControlByName('jqxRunOnlyMinTime_Input');
                 LoadRegistryItemToControlByName('jqxRunOnlyMaxTime_Input');
                 LoadRegistryItemToControlByName('jqxIgnoreTimeWindowOnWeekendsCb');
                 LoadRegistryItemToControlByName('jqxStopRunningProfilesCb');
                 LoadRegistryItemToControlByName('jqxInterruptMiddleOfFileCb');
                 bScheduleWeekdaysTabCreated = true;
                              
              }
              else if ((ItemIndex == 3) && (bSheduleMonitoringTabCreated == false))
              {

               //Schedule Monitoring/Real-Time Sync
                 LoadRegistryItemToControlByName('jqxRealTimeSynchronizationCb');
                 LoadRegistryItemToControlByName('jqxRealContinuousSyncCb');
                 $("#btnRealTimeSettings").jqxButton({ theme: GTheme });
                 $('#btnRealTimeSettings').off('click');
                 $('#btnRealTimeSettings').click(function () {
                     var client = new XMLHttpRequest();
                     client.open('GET', '/RealTimeSettingsDlg.html');
                     client.onreadystatechange = function()
                     {
                        if (client.readyState == XMLHttpRequest.DONE)
                        {
                           HTML_RealTimeSettingsDlg = client.responseText;
                           $("#HTML_RealTimeSettingsDlg_div").html( HTML_RealTimeSettingsDlg );
                           setTimeout(ShowRealTimeSettingsDlg, 100);
                        }
                     }
                     client.send();
                 });

                 LoadRegistryItemToControlByName('jqxRealProfileAsSoonAsDriveAvailableCb');
                 $("#Real_Once_Mode").jqxRadioButton({groupName :"Real_MonitoringRunOnlyOnceWidget"});
                 $("#Real_Repeatedly_Mode").jqxRadioButton({groupName :"Real_MonitoringRunOnlyOnceWidget"});
                 LoadRegistryItemToControlByName('Real_MonitoringRunOnlyOnceWidget');
                 LoadRegistryItemToControlByName('jqx_RealMonitoringIntervalMinutes');
                 LoadRegistryItemToControlByName('jqx_RealMonitoringIntervalSeconds');
                 LoadRegistryItemToControlByName('jqxRealUseMinimumPauseCb');
                 LoadRegistryItemToControlByName('jqx_RealPauseHoursInput');
                 LoadRegistryItemToControlByName('jqx_RealPauseMinutesInput');
                 LoadRegistryItemToControlByName('jqx_RealPauseSecondsInput');

                 bSheduleMonitoringTabCreated = true;
              };

                           
              EnableDisableRealProfileAsSoonAsDriveAvailable();
              ScheduleTabControlsEnableDisable();
           });
           ScheduleTabControlsEnableDisable();
           break;
         case "errors":
           if (!bTabErrorsCreated)
           {
             LoadRegistryItemToControlByName('jqxFAIgnoreAccessDeniedFoldersCb');
             LoadRegistryItemToControlByName('jqxFAIgnoreAccessDeniedFilesCb');
             LoadRegistryItemToControlByName('jqxFAIgnoreMissingFilesCb');
             LoadRegistryItemToControlByName('jqxFAIgnoreLockedFilesOnDestCb');
             LoadRegistryItemToControlByName('jqxFAIgnoreDeletionErrorsCb');
             LoadRegistryItemToControlByName('jqxFAIgnoreDeletingFolderErrorsCb');

             bTabErrorsCreated = true;
           }
           break;

       case "retries":
          if (!bTabRetriesCreated)
          {
             LoadRegistryItemToControlByName('jqxWRWaitForFileAccessCb');
             LoadRegistryItemToControlByName('inptWRWaitUpToMin');
             LoadRegistryItemToControlByName('jqxWRWaitIfTransferProblemCb');
             LoadRegistryItemToControlByName('jqxWRBuildingFileListCb');
             LoadRegistryItemToControlByName('jqxWRRunningTheProfileCb');
             $("#Re_Run_Once_Radio_Mode").jqxRadioButton({groupName :"WRReRunRadiogroupWidget"});
             $("#Re_Run_Until_Success_Radio_Mode").jqxRadioButton({groupName :"WRReRunRadiogroupWidget"});
             $("#Max_Re_Runs_Radio_Mode").jqxRadioButton({groupName :"WRReRunRadiogroupWidget"});
             LoadRegistryItemToControlByName('WRReRunRadiogroupWidget');
             LoadRegistryItemToControlByName('inptWRMaxReRuns');
             LoadRegistryItemToControlByName('inptWRRetryAfter');
             LoadRegistryItemToControlByName('jqxWRAvoidRerunDueToLockedCb');
             bTabsAccessWaitingCreated = true;
          }
          EnableDisableWaitingAndRetrying();
          break;

       case "comp":
           $('#jqxTabsComparison').jqxTabs({ width: GInnerTabControlWidth, height: GInnerTabControlHeight, keyboardNavigation: false});
            //Comparison
             // alert('Tab Comparison');
             if (!GbTabsComparisonCreated)
             {
              LoadRegistryItemToControlByName('jqxComparIgnoreSmallTimeDiffCb');
              LoadRegistryItemToControlByName('inptComparIgnoreSec');
              LoadRegistryItemToControlByName('jqxComparIgnoreExactHourTimeDiffCb');
              LoadRegistryItemToControlByName('inptComparIgnoreHours');
              LoadRegistryItemToControlByName('jqxComparIgnoreSecondsCb');
              LoadRegistryItemToControlByName('jqxComparIgnoreTimestampAlltogetherCb');
              LoadRegistryItemToControlByName('jqxComparAdjustTimestampOnlyCb');
              $("#Ask_Radio_Mode").jqxRadioButton({groupName :"ComparWhenSizeIsDiffentRadiogroupWidget"});
              $("#Copy_Left_To_Right_Radio_Mode").jqxRadioButton({groupName :"ComparWhenSizeIsDiffentRadiogroupWidget"});
              $("#Copy_Right_To_Left_Radio_Mode").jqxRadioButton({groupName :"ComparWhenSizeIsDiffentRadiogroupWidget"});
              $("#Copy_Larger_Files_Radio_Mode").jqxRadioButton({groupName :"ComparWhenSizeIsDiffentRadiogroupWidget"});
              $("#SizeDiffCopy").jqxRadioButton({groupName :"ComparWhenSizeIsDiffentRadiogroupWidget"});
              $("#SizeDiffIgnore").jqxRadioButton({groupName :"ComparWhenSizeIsDiffentRadiogroupWidget"});

              var l2r = GetCheckBoxValue("jqxLeftToRightCb");
              var r2l = GetCheckBoxValue("jqxRightToLeftCb");
              if (l2r == r2l)
                 ShowTwoWayRadios();
              else
                 ShowOneWayRadios();

              LoadRegistryItemToControlByName('ComparWhenSizeIsDiffentRadiogroupWidget');

              GbTabsComparisonCreated = true;

            };

           $('#jqxTabsComparison').on('selecting', function (event)
           {
              var ItemIndex = event.args.item;
              if (ItemIndex == 0)
              {
                // initialized above
              }
              else if ((ItemIndex == 1) && (GbTabsComparisonMoreCreated == false))
              {
                 // Comparison->More
                 LoadRegistryItemToControlByName('jqxComparMoreAlwaysCopyFilesCb');
                 LoadRegistryItemToControlByName('jqxComparStripReadOnlyAttrCb');

                 if (GisSyncoveryWindows)
                 {
                    LoadRegistryItemToControlByName('jqxComparMoreFileAttrCb');
                    LoadRegistryItemToControlByName('jqxComparMoreFolderAttrCb');
                    LoadRegistryItemToControlByName('jqxComparMoreDetectHardLinksCb');
                 }
                 else
                 {
                    $('#jqxComparMoreFileAttrCb').css({"display":"none"});
                    $('#jqxComparMoreFolderAttrCb').css({"display":"none"});
                 }

                 LoadRegistryItemToControlByName('jqxComparMoreCaseSensitivityCb');
                 LoadRegistryItemToControlByName('jqxComparMoreFolderTimesCb');
                 LoadRegistryItemToControlByName('jqxComparMoreEnforceHardLinksCb');
                 GbTabsComparisonMoreCreated = true;
              }
             EnableDisableComparison();
           });
           EnableDisableComparison();
           break;
       case "files":
          $('#jqxTabsFiles').jqxTabs({ width: GInnerTabControlWidth, height: GInnerTabControlHeight, keyboardNavigation: false});
          if (GbTabFiles == false)
          {
            LoadRegistryItemToControlByName('jqxFilesDetectMovedFilesCb');
            $("#Files_Left_Radio_Mode").jqxRadioButton({groupName :"FilesDetectMovedFilesRadiogroupWidget"});
            $("#Files_Right_Radio_Mode").jqxRadioButton({groupName :"FilesDetectMovedFilesRadiogroupWidget"});
            $("#Files_Automatic_Radio_Mode").jqxRadioButton({groupName :"FilesDetectMovedFilesRadiogroupWidget"});
            LoadRegistryItemToControlByName('jqxAllowMovesBetweenUsers');
            LoadRegistryItemToControlByName('jqxSkipMoves');
            LoadRegistryItemToControlByName('jqxDetectMovedFolders');
            LoadRegistryItemToControlByName('FilesDetectMovedFilesRadiogroupWidget');
            LoadRegistryItemToControlByName('jqxFilesDetectRenamedFilesCb');
            LoadRegistryItemToControlByName('jqxFilesAutomaticallyResumeCb');
            LoadRegistryItemToControlByName('jqxFilesProtectFromBeingReplacedCb');
            LoadRegistryItemToControlByName('jqxFilesDoNotScanDestinationCb');
            LoadRegistryItemToControlByName('inptFilesNumberToCopyInparallel');
            LoadRegistryItemToControlByName('inptFilesSplitLargeFiles');
            LoadRegistryItemToControlByName('jqxFilesMore_SpeedLimit');
            LoadRegistryItemToControlByName('inptFilesMore_SpeedLimit');
            LoadRegistryItemToControlByName('jqxSpeedLimitAdvancedCb');
            GSpeedLimitAdvanced=GetCheckBoxValue('jqxSpeedLimitAdvancedCb');
            LoadRegistryItemToControlByName('jqxFilesMore_SkipIfFileSizeChanging');
            GbTabFiles = true;
         }

          $('#jqxTabsFiles').on('selecting', function (event)
           {

              var ItemIndex = event.args.item;
              if (ItemIndex == 0)
              {

              }
              else if ((ItemIndex == 1) && !GbTabBlockLevelCopying)
              {
                // Block Level Copying
                LoadRegistryItemToControlByName('jqxSpecialSpFeatr_UsePartialFileUpdatingCb');
                LoadRegistryItemToControlByName('cbUseRemServToCopyFiles');

                $("#rbBlockLevelChecksums").jqxRadioButton({groupName :"BlockLevelRadiogroupWidget"});
                $("#rbBlockLevelFileSystemMonitoring").jqxRadioButton({groupName :"BlockLevelRadiogroupWidget"});
                LoadRegistryItemToControlByName('BlockLevelRadiogroupWidget');
                LoadRegistryItemToControlByName('jqxSpecialSpFeatr_RightSideRemoteServiceCb');
                LoadRegistryItemToControlByName('jqxSpecial_DontFallBackFromPartialCb');
                LoadRegistryItemToControlByName('jqxSpecial_PartialRemoteOneByOneCb');
                LoadRegistryItemToControlByName('jqxSpecialSpFeatr_FastModeCb');
              }
              else if ((ItemIndex == 2) && !GbTabFilesDeletions)
              {
                // Files -> Deletions

                if (GisSyncoveryLinux)
                {
                   $('#jqxFilesDeletions_RecycleBinExplainer').html("The Recycle Bin is only available on some cloud storages<br>(not on local hard drives or mounted network shares).");
                }

                LoadRegistryItemToControlByName('jqxFilesDeletions_OverwrittenFiles');
                LoadRegistryItemToControlByName('jqxFilesDeletions_DeletedFiles');
                LoadRegistryItemToControlByName('jqxFilesDeletions_MoveFilesToSFolder');
                $("#btnFiles_EditPaths").jqxButton({ theme: GTheme });
                $('#btnFiles_EditPaths').off('click');
                $('#btnFiles_EditPaths').click(function () {
                                
                     var client = new XMLHttpRequest();
                     client.open('GET', '/FoldersForDeletedFiles.html');
                     client.onreadystatechange = function()
                     {
                        if (client.readyState == XMLHttpRequest.DONE)
                        {
                           HTML_FoldersForDeletedFilesDlg = client.responseText;
                           $("#HTML_FoldersForDeletedFilesDlg_div").html( HTML_FoldersForDeletedFilesDlg );
                           setTimeout(ShowFoldersForDeletedFilesDlg, 100);
                        }
                     }
                     client.send();

                 });
                LoadRegistryItemToControlByName('jqxFilesDeletions_DeleteOlderVersionsPermamently');
                LoadRegistryItemToControlByName('jqxFilesDeletions_RememberDeletionTime');
                LoadRegistryItemToControlByName('jqxFilesDeletions_DoubleCheckNonExistence');
                LoadRegistryItemToControlByName('jqxFilesDeletions_NeverDelete');
                LoadRegistryItemToControlByName('jqxFilesDeletions_DeleteBeforeCopying');

                GbTabFilesDeletions = true;

              }
             else if ((ItemIndex == 3) && !bTabFilesMore)
              {
               //Files More
                if (GisSyncoveryWindows)
                   LoadRegistryItemToControlByName('jqxFilesMore_UseWindowsApi');
                LoadRegistryItemToControlByName('jqxFilesMore_CopyOnlyFilesPerRun');
                LoadRegistryItemToControlByName('inptFilesMore_FilesPerRun');
                LoadRegistryItemToControlByName('jqxFilesMore_CopyOnlyMBPerRun');
                LoadRegistryItemToControlByName('inptFilesMore_MBPerRun');
                LoadRegistryItemToControlByName('jqxFilesMore_CopiedFilesSysTime');
                LoadRegistryItemToControlByName('jqxFilesMore_NeverReplace');
                LoadRegistryItemToControlByName('jqxFilesMore_DontAddAnyFiles');
                LoadRegistryItemToControlByName('jqxFilesMore_AlwaysAppend');
                LoadRegistryItemToControlByName('jqxFilesMore_IgnoreGlobalSpeedLimit');
                LoadRegistryItemToControlByName('jqxFilesMore_AlwaysConsider');
                LoadRegistryItemToControlByName('jqxFilesMore_AndCompareFileDetails');
                LoadRegistryItemToControlByName('jqxFilesMore_ViaInternetProtocolsToo');
                LoadRegistryItemToControlByName('jqxFilesMore_CheckDestinationFile');
                LoadRegistryItemToControlByName('jqxFilesMore_PreserveLastAccessOnSource');
                LoadRegistryItemToControlByName('jqxFilesMore_UseTempFilesCloudToCloud');
                LoadRegistryItemToControlByName('jqxFilesBypassFileBufferingLeftCb');
                LoadRegistryItemToControlByName('jqxFilesBypassFileBufferingRightCb');

                if (GisSyncoveryWindows)
                   LoadRegistryItemToControlByName('jqxFilesMore_CreateLinksInsteadOfCopying');
                else
                   $('#jqxFilesMore_CreateLinksInsteadOfCopying').css({"display":"none"});

                bTabFilesMore = true;
              }
             else if ((ItemIndex == 4) && !bTabFileAccess)
             {
                if (GisSyncoveryWindows)
                {
                    $("#Do_not_Use_Radio_Mode").jqxRadioButton({groupName :"VolumeShadowingRadiogroupWidget"});
                    $("#Use_to_copy_locked_files_Radio_Mode").jqxRadioButton({groupName :"VolumeShadowingRadiogroupWidget"});
                    $("#Use_for_all_files_Radio_Mode").jqxRadioButton({groupName :"VolumeShadowingRadiogroupWidget"});
                    $("#Use_for_all_Create_Radio_Mode").jqxRadioButton({groupName :"VolumeShadowingRadiogroupWidget"});
                    LoadRegistryItemToControlByName('VolumeShadowingRadiogroupWidget');
                }
                else
                {
                    $('#VolShad_lbl').css({"display":"none"});
                    $('#Do_not_Use_Radio_Mode').css({"display":"none"});
                    $('#Use_to_copy_locked_files_Radio_Mode').css({"display":"none"});
                    $('#Use_for_all_files_Radio_Mode').css({"display":"none"});
                    $('#Use_for_all_Create_Radio_Mode').css({"display":"none"});
                }
                LoadRegistryItemToControlByName('jqxFADatabaseSafeCopyCb');
                LoadRegistryItemToControlByName('jqxFATakeAdminOwnershipCb');
                LoadRegistryItemToControlByName('jqxFAVerifyOpeningPriorCopyCb');

                bTabFileAccess=true;
             }
             EnableDisableFiles();
           });
           EnableDisableFiles();
          break;

       case "folders":
          $('#jqxTabsFolders').jqxTabs({ width: GInnerTabControlWidth, height: GInnerTabControlHeight, keyboardNavigation: false });
          break;

       case "job":
          // nothing to do here
          break;

       case "masks":
          $('#jqxTabsMasks').jqxTabs({ width: GInnerTabControlWidth, height: GInnerTabControlHeight, keyboardNavigation: false});
           if (bTabsMasks == false)
           {
             LoadRegistryItemToControlByName('inptInclusionMasks');
             LoadRegistryItemToControlByName('jqxMasks_SpecFolderMasksCb');
             LoadRegistryItemToControlByName('jqxMasks_RestrictionsCb');
             LoadRegistryItemToControlByName('jqxMasks_IncludeBackupFilesCb');
             bTabsMasks = true;
           }
           $('#jqxTabsMasks').on('selecting', function (event)
           {
              var ItemIndex = event.args.item;
              if (ItemIndex == 0)
              {
                 // Inclusion Masks
              }
              else if ((ItemIndex == 1) && (bTabsMasksExclusionMasks == false))
              {
                // Exclusion Masks
                $("#Masks_DontCopy_Radio_Mode").jqxRadioButton({groupName :"ExclucionFilesWidget"});
                $("#Masks_IgnoreTotaly_Radio_Mode").jqxRadioButton({groupName :"ExclucionFilesWidget"});
                LoadRegistryItemToControlByName('ExclucionFilesWidget');
                LoadRegistryItemToControlByName('inptExclusionMasks');
                LoadRegistryItemToControlByName('jqxMasks_UseGlobalExclAlsoCb');
                bTabsMasksExclusionMasks = true;
              }
              EnableDisableMasks();
              $('#jqxTabsMasks').jqxTabs('focus');
           });
          EnableDisableMasks();
          break;

       case "filters":
          $('#jqxTabsFilters').jqxTabs({ width: GInnerTabControlWidth, height: GInnerTabControlHeight, keyboardNavigation: false});
           if (!bTabsFilters)
           {
             // General Filters
             LoadRegistryItemToControlByName('jqxMasks_ProcessHiddenFilesCb');
             LoadRegistryItemToControlByName('jqxMasks_SearchHiddenFoldersCb');

             if (GisSyncoveryWindows)
             {
                $('#GeneralFiltersExplainer').css({"display":"none"});
             }
             else
             {
                $('#jqxMasks_CopyFilesWithArchiveFlagCb').html("Copy Only Files That Haven't Been Marked As Copied (or Have Changed Since)");
                $('#jqxMasks_ClearArchiveFlagsCb').html("Mark Copied Files With an Extended Attribute");

                $('#genfilrowxcol1').html($('#genfilrowxcol2').html());
                $('#genfilrowxcol2').html("");
             }

             LoadRegistryItemToControlByName('jqxMasks_CopyFilesWithArchiveFlagCb');
             LoadRegistryItemToControlByName('jqxMasks_ClearArchiveFlagsCb');

             LoadRegistryItemToControlByName('cbRestoreDeletedItems');
             LoadRegistryItemToControlByName('cbSymlinkFilesLeft');
             LoadRegistryItemToControlByName('cbSymlinkFilesRight');
             LoadRegistryItemToControlByName('cbSkipOfflineFiles');

             if (GisSyncoveryWindows)
             {
                LoadRegistryItemToControlByName('cbCopyPinnedFilesOnlyLeft');
                LoadRegistryItemToControlByName('cbCopyPinnedFilesOnlyRight');
                LoadRegistryItemToControlByName('jqxMasks_ProcessReparsePointsCb');
                LoadRegistryItemToControlByName('jqxMasks_FollowJunctionPointsFilesCb');
                LoadRegistryItemToControlByName('jqxMasks_FollowJunctionPointsFoldersCb');
                LoadRegistryItemToControlByName('jqxMasks_CopyOtherReparsePointsCb');
                LoadRegistryItemToControlByName('jqxFollowLnkLinks');

                $('#SymLinksSpacer').css({"display":"none"});
                $('#SymLinksFilesRow').css({"display":"none"});
                $('#SymLinksFoldersRow').css({"display":"none"});
             }
             else
             {
                $('#cbCopyPinnedFilesOnlyLeft').css({"display":"none"});
                $('#cbCopyPinnedFilesOnlyRight').css({"display":"none"});
                $('#jqxFollowLnkLinks').css({"display":"none"});
                $('#jprow1').css({"display":"none"});
                $('#jprow2').css({"display":"none"});
                $('#jprow3').css({"display":"none"});
                $("#SymLinksFilesIgnore").jqxRadioButton({groupName :"SymLinksFiles"});
                $("#SymLinksFilesFollow").jqxRadioButton({groupName :"SymLinksFiles"});
                $("#SymLinksFilesCopy").jqxRadioButton({groupName :"SymLinksFiles"});
                $("#SymLinksFoldersIgnore").jqxRadioButton({groupName :"SymLinksFolders"});
                $("#SymLinksFoldersFollow").jqxRadioButton({groupName :"SymLinksFolders"});
                $("#SymLinksFoldersCopy").jqxRadioButton({groupName :"SymLinksFolders"});
                LoadRegistryItemToControlByName('SymLinksFiles');
                LoadRegistryItemToControlByName('SymLinksFolders');
             }
             bTabsFilters = true;
           }
           $('#jqxTabsFilters').on('selecting', function (event)
           {
              var ItemIndex = event.args.item;
              if (ItemIndex == 0)
              {
                 // General Filters
              }
              else if ((ItemIndex == 1) && !bTabsFiltersFileAge)
              {
                // File Age and Size
                LoadRegistryItemToControlByName('jqxMasks_FileSizesWithinCb');
                LoadRegistryItemToControlByName('jqxMasks_FileDatesWithinCb');
                LoadRegistryItemToControlByName('jqxInptMasks_FileSizesMin');
                LoadRegistryItemToControlByName('jqxInptDateMasks_FileMinDate');
                LoadRegistryItemToControlByName('jqxInptMasks_FileSizesMax');
                LoadRegistryItemToControlByName('jqxInptDateMasks_FileMaxDate');
                LoadRegistryItemToControlByName('jqxMasks_FileAgeCb');
                LoadRegistryItemToControlByName('jqxMasks_FileAgeCombo');
                LoadRegistryItemToControlByName('inptMasks_FileAgeDays');
                LoadRegistryItemToControlByName('inptMasks_FileAgeHours');
                LoadRegistryItemToControlByName('inptMasks_FileAgeMinutes');
                LoadRegistryItemToControlByName('jqxMasks_TargetDataRestoreCb');
                LoadRegistryItemToControlByName('jqxInptDateMasks_TargetDateRestoreDate');
                LoadRegistryItemToControlByName('jqxInptDateMasks_TargetDateRestoreTime');
                LoadRegistryItemToControlByName('cbScanOnlyFoldersModifiedSinceLastRun');
                $("#Masks_LastModification_Radio_Mode").jqxRadioButton({groupName :"Masks_FilterByWidget"});

                if (GisSyncoveryLinux)
                {
                   $("#Masks_Creation_Radio_Mode").html("Node Change");
                   $("#Masks_LastAccess_Radio_Mode").css({"display":"none"});
                }
                $("#Masks_Creation_Radio_Mode").jqxRadioButton({groupName :"Masks_FilterByWidget"});
                $("#Masks_LastAccess_Radio_Mode").jqxRadioButton({groupName :"Masks_FilterByWidget"});

                LoadRegistryItemToControlByName('Masks_FilterByWidget');
                $("#Masks_ApplyToFiles_Radio_Mode").jqxRadioButton({groupName :"Masks_ApplyToWidget"});
                $("#Masks_ApplyToFolders_Radio_Mode").jqxRadioButton({groupName :"Masks_ApplyToWidget"});
                $("#Masks_ApplyToBoth_Radio_Mode").jqxRadioButton({groupName :"Masks_ApplyToWidget"});
                LoadRegistryItemToControlByName('Masks_ApplyToWidget');
                LoadRegistryItemToControlByName('cbScanOnlyFoldersModifiedSinceLastRun');
                bTabsFiltersFileAge = true;
              }

              EnableDisableFilters();
              $('#jqxTabsFilters').jqxTabs('focus');
           });
          EnableDisableFilters();
          break;

       case "safety":
         $('#jqxTabsSafety').jqxTabs({ width: GInnerTabControlWidth, height: GInnerTabControlHeight, keyboardNavigation: false});
         if (!bTabsSafety)
         {
           LoadRegistryItemToControlByName('jqxSafety_WarnIfMovingFiles');
           LoadRegistryItemToControlByName('jqxSafety_WarnBeforeOverridingReadOnly');
           LoadRegistryItemToControlByName('jqxSafety_WarnBeforeOverridingLarger');
           LoadRegistryItemToControlByName('jqxSafety_WarnBeforeOverridingNewer');
           LoadRegistryItemToControlByName('jqxSafety_WarnBeforeDeleting');

           if (GisSyncoveryWindows)
              $('#AttendedModeWarningsComment').css({"display":"none"});

           bTabsSafety = true;
         }

          $('#jqxTabsSafety').on('selecting', function (event)
           {
                           
              var ItemIndex = event.args.item;
              if (ItemIndex == 0)
              {
               //Attended Mode
              }
              else if ((ItemIndex == 1) && (bTabsSafetySafety == false))
              {
               //Special Safety
                LoadRegistryItemToControlByName('jqxSafetySpecial_WarnIfDeletingFilesMoreThan');
                LoadRegistryItemToControlByName('inptSafetySpecial_WarnIfDeletingFilesMoreThan');
                LoadRegistryItemToControlByName('jqxSafetySpecial_WarnIfDeletingAllFilesInAnySubfolder');
                LoadRegistryItemToControlByName('jqxSafetySpecial_WarnIfDeletingMoreThanInAnySubfolder');
                LoadRegistryItemToControlByName('inptSafetySpecial_WarnIfDeletingMoreThanInAnySubfolder');
                bTabsSafetySafety = true;
                EnableDisableSafety();
              }
              else if ((ItemIndex == 2) && (bTabsSafetyUnattended == false))
              {
                 //Unattended Mode
                 LoadRegistryItemToControlByName('jqxSafetyUnattended_OverwriteReadOnly');
                 LoadRegistryItemToControlByName('jqxSafetyUnattended_OverwriteLarge');
                 LoadRegistryItemToControlByName('jqxSafetyUnattended_NewerFilesCanBeOverwritten');
                 LoadRegistryItemToControlByName('jqxSafetyUnattended_FileDeletionAllowedCb');
                 LoadRegistryItemToControlByName('inptSafetyUnattended_FileDeletionAllowed');
                 LoadRegistryItemToControlByName('inptSafetyUnattended_DeleteMaxFiles');
                 LoadRegistryItemToControlByName('jqxSafetyUnattended_ReplaceMaxPercentCb');
                 LoadRegistryItemToControlByName('inptSafetyUnattended_ReplaceMaxPercent');
                 LoadRegistryItemToControlByName('jqxSafetyUnattended_EnableSpecialSafetyCheck');
                 EnableDisableSafetyUnattended();
                 bTabsSafetyUnattended = true;
              }
                          
          });
                      
         break;
       case "special":
         $('#jqxTabsSpecial').jqxTabs({ width: GInnerTabControlWidth, height: GInnerTabControlHeight, keyboardNavigation: false});

         if (!Gb_TabSpecial)
         {
            if (GisSyncoveryWindows)
               LoadRegistryItemToControlByName("jqxSpecialSpFeatr_ProcessSecurityCb");
            else
            {
               $('#jqxSpecialSpFeatr_ProcessSecurityCb').html('<button id="SecurityMoreBtn">&nbsp; File and Folder Security (Permissions)... &nbsp;</button>');
               $("#SecurityMoreBtn").jqxButton({ theme: GTheme, height: GBtnHeight, width: GBtnWidthMini});
               $('#SecurityMoreBtn').off('click');
               $("#SecurityMoreBtn").click(function ()
                 {
                    DoShow_Special_SecurityAndSharesDlg();
                 });

            }

            var HTML_Special_AlternateDataStreamsDlg = "";

            if (!GisSyncoveryWindows)
               $("#btnSpecial_AlternateDataStreams").html("&nbsp; Extended Attributes... &nbsp;");

            $("#btnSpecial_AlternateDataStreams").jqxButton({ theme: GTheme });

            $('#btnSpecial_AlternateDataStreams').off('click');
            $('#btnSpecial_AlternateDataStreams').click(function () {
                if (HTML_Special_AlternateDataStreamsDlg == "" )
                {
                  var client = new XMLHttpRequest();
                  if (GisSyncoveryWindows)
                     client.open('GET', '/Special_AlternateDataStreamsDlg.html');
                  else
                     client.open('GET', '/ExtAttrDlg.html');
                  client.onreadystatechange = function()
                  {
                     if (client.readyState == XMLHttpRequest.DONE)
                     {
                       HTML_Special_AlternateDataStreamsDlg = client.responseText;
                       if (HTML_Special_AlternateDataStreamsDlg != "")
                       {
                         $("#HTML_Special_AlternateDataStreamsDlg_div").html( HTML_Special_AlternateDataStreamsDlg );
                         setTimeout(ShowSpecial_AlternateDataStreamsDlg, 100);
                       }
                     }
                  }
                  client.send();
                }
                else
                  ShowSpecial_AlternateDataStreamsDlg();
              });

            GetHTMLintoVar('Special_CacheDestinationFileListDlg.html', 'HTML_CacheDestinationFileListDlg');
            $("#jqxSpecialSpFeatr_CacheDestinationFileListCb").jqxCheckBox({ width: 250, height: 25, checked : GSpecial_CacheDestinationFileList });
            $("#jqxSpecialSpFeatr_CacheDestinationFileListCb").on('click', Show_Special_CacheDestinationFileListDlg );

            LoadRegistryItemToControlByName('jqxCopyingOrder');
            LoadRegistryItemToControlByName('jqxSpecialSpFeatr_LeftSideUsesRemoteServiceCb');

            LoadRegistryItemToControlByName('jqxSpecialSpFeatr_RightSideUsesRemoteServiceCb');
            LoadRegistryItemToControlByName('jqxSpecialSpFeatr_UseDifferentFoldersCb');

            $("#btnCommunicationPaths").jqxButton({ theme: GTheme, height: GBtnHeight, width: GChooseFolderFilesBtnWidth });
            $('#btnCommunicationPaths').off('click');
            $("#btnCommunicationPaths").click(function ()
              {
                if (HTML_Special_PathsForCommunicationDlg == "" )
                {
                   var client = new XMLHttpRequest();
                   client.open('GET', '/PathsForCommunicationDlg.html');
                   client.onreadystatechange = function()
                   {
                     if (client.readyState == XMLHttpRequest.DONE)
                     {
                       HTML_Special_PathsForCommunicationDlg = client.responseText;
                       if (HTML_Special_PathsForCommunicationDlg != "")
                       {
                          $("#HTML_Special_PathsForCommunicationDlg_div").html( HTML_Special_PathsForCommunicationDlg );
                          setTimeout(Special_PathsForCommunicationDlg, 100);
                       }
                     }
                   }
                   client.send();
                }
                else
                  Special_PathsForCommunicationDlg();
             });


            Gb_TabSpecial = true;
          }

           $('#jqxTabsSpecial').on('selecting', function (event)
           {
              var ItemIndex = event.args.item;
              if (ItemIndex == 0)
              {
                 // Special Features - nothing to do, controls already shown (see case "special" above)
              }
              else
              if (ItemIndex == 1)
              {
                 // Special -> More
                 LoadRegistryItemToControlByName('cbRedownloadServerModifiedUploads');
                 if (GisSyncoveryWindows)
                 {
                    LoadRegistryItemToControlByName('inptSpecialSpFeatr_SetTargetVolumeLabel');
                    LoadRegistryItemToControlByName('cbDetectChangedFilesViaMonitoring');
                 }
                 else
                 {
                     $('#inptSpecialSpFeatr_SetTargetVolumeLabel').css({"display":"none"});
                     $('#cbDetectChangedFilesViaMonitoring').css({"display":"none"});
                 }
                 LoadRegistryItemToControlByName('jqxFilesMore_DeleteFilesViaRemoteService');
                 LoadRegistryItemToControlByName('jqxFilesMore_MoveFilesViaRemoteService');
                 LoadRegistryItemToControlByName('cbDoubleCheckTimestamps');
                 LoadRegistryItemToControlByName('cbSpawnSeparateSubJobs');
                 LoadRegistryItemToControlByName('inptSpawnSeparateSubJobs');
                 LoadRegistryItemToControlByName('cbSpawnSimultaneously');

              }
              else
              if ((ItemIndex == 2) && (bTabsSpecialDatabase == false))
              {
                 // Database
                 LoadRegistryItemToControlByName('jqxSpDb_OpenDatabaseReadOnlyCb');
                 LoadRegistryItemToControlByName('jqxSpDb_NeverOutdateDatabaseCb');
                 LoadRegistryItemToControlByName('jqxSpecialDatabase_FastModeCb');
                 LoadRegistryItemToControlByName('inptSpecialDatabase_DatabaseNameToUse');
                 LoadRegistryItemToControlByName('inptSpecialDatabase_Left');
                 LoadRegistryItemToControlByName('inptSpecialDatabase_Right');
                 $("#btnDeleteDB").jqxButton({ height: GBtnHeight, width: GBtnWidthMini,theme: GTheme});
                 $('#btnDeleteDB').off('click');
                 $('#btnDeleteDB').click(function ()
                  {
                     var sendparams = { };
                     sendparams.token = GClientToken;
                     sendparams.ProfileName = GSelectedProfileName;
                     $.post( "deleteprofiledb.php",JSON.stringify(sendparams));
                  });
                 bTabsSpecialDatabase = true;

              }
              EnableDisableSpecial();
            });
         EnableDisableSpecial();
         break;

       case "verification":
         if (!bTabsVerification)
         {
            $('#jqxTabsVerification').jqxTabs({ width: GInnerTabControlWidth, height: GInnerTabControlHeight, keyboardNavigation: false});
            LoadRegistryItemToControlByName('jqxFilesVerifyCopiedFilesCb');
            LoadRegistryItemToControlByName('jqxFilesReCopyOnceCb');

            LoadRegistryItemToControlByName('jqxComparMoreBinaryComparisonCb');
            LoadRegistryItemToControlByName('jqxComparMoreBinCompRememberCb');
            LoadRegistryItemToControlByName('jqxComparMoreBinaryLeftSideCb');
            LoadRegistryItemToControlByName('jqxComparMoreBinaryRightSideCb');
            LoadRegistryItemToControlByName('jqxComparMoreVerifySyncStatisticsCb');
            LoadRegistryItemToControlByName('cbUseSHA256');

            LoadRegistryItemToControlByName('jqxVerifyLeftFileIntegrityDuringScanning');
            LoadRegistryItemToControlByName('jqxVerifyRightFileIntegrityDuringScanning');
            LoadRegistryItemToControlByName('jqxVerifyFileIntegrityDuringScanningOnlyFilesWithoutAction');
            LoadRegistryItemToControlByName('jqxVerifySourceFileIntegrityBeforeCopying');
            LoadRegistryItemToControlByName('jqxVerifyDestinationFileIntegrityAfterCopying');
            LoadRegistryItemToControlByName('jqxVerifyFileIntegrityCopyAnyway');
            LoadRegistryItemToControlByName('jqxVerificationDepth');

            LoadRegistryItemToControlByName('jqxFileInspectionForMasks');
            LoadRegistryItemToControlByName('jqxInspectArchives');
            LoadRegistryItemToControlByName('jqxDisallowEncryptedArchives');

            bTabsVerification=true;
         }
         break;

       case "versioning":
         $('#jqxTabsVersioning').jqxTabs({ width: GInnerTabControlWidth, height: GInnerTabControlHeight, keyboardNavigation: false});
         if (!bTabsVersioning)
         {
           LoadRegistryItemToControlByName('jqxVersVers_KeepOlderVersionsWhenReplacing');
           LoadRegistryItemToControlByName('inptVersVers_PerFile');
           $("#VersVers_Add_Prefix_Mode").jqxRadioButton({groupName :"VersVers_RenamingOlderVersionsWidget"});
           $("#VersVers_Add_Timestamp_Mode").jqxRadioButton({groupName :"VersVers_RenamingOlderVersionsWidget"});
           LoadRegistryItemToControlByName('VersVers_RenamingOlderVersionsWidget');
           LoadRegistryItemToControlByName('jqxVersVers_OnlyOnRightHandSide');
           LoadRegistryItemToControlByName('jqxVersVers_MoveIntoFolder');
           LoadRegistryItemToControlByName('inptMoveIntoFolderLeft');
           LoadRegistryItemToControlByName('inptMoveIntoFolder');
           LoadRegistryItemToControlByName('jqxVersVers_AsSubfolerInEachFolderCb');
           LoadRegistryItemToControlByName('jqxVersVers_RecreateTreeBelowCb');
           LoadRegistryItemToControlByName('jqxVersVers_DontRenameNewestOlderVersionCb');
           LoadRegistryItemToControlByName('jqxVersVers_KeepOneVersionOfDeletedFilesCb');
           LoadRegistryItemToControlByName('jqxVersVers_FileNameEncodingCb');
           LoadRegistryItemToControlByName('cbDeleteOldVersions');
           LoadRegistryItemToControlByName('edDeleteOldVersionsAfterDays');
           bTabsVersioning = true;
          };
           $('#jqxTabsVersioning').on('selecting', function (event)
           {
              var ItemIndex = event.args.item;
              if (ItemIndex == 0)
              {
                //Versioning
              }
              else if ((ItemIndex == 1) && (bTabsVersioningSynthetic == false))
              {
                 // Synthetic backup
                 LoadRegistryItemToControlByName('jqxVersSynth_UseSynthBackupsCb');
                 LoadRegistryItemToControlByName('jqxVersSynth_UseCheckPointsCb');
                 LoadRegistryItemToControlByName('jqxVersSynth_CreateCheckpointCombo');
                 LoadRegistryItemToControlByName('jqxVersSynth_CheckpointsRelativeCombo');
                 LoadRegistryItemToControlByName('jqxVersSynth_BuildAllIncrementalCb');
                 LoadRegistryItemToControlByName('jqxVersSynth_RemoveUnneededCb');
                 LoadRegistryItemToControlByName('inptVersSynth_RemoveUnneeded');
                 LoadRegistryItemToControlByName('jqxVersSynth_RemoveUnneededCombo');
                 LoadRegistryItemToControlByName('jqxVersSynth_IfAllBlocksCb');
                 EnableDisableVersionsSynthBackup();
                 bTabsVersioningSynthetic = true;
              }
              else if ((ItemIndex == 2) && (bTabsVersioningMore == false))
              {
               //More
                 LoadRegistryItemToControlByName('jqxVersMore_DoNotDecodeLeftHandCb');
                 LoadRegistryItemToControlByName('jqxVersMore_DoNotDecodeRightHandCb');
                 LoadRegistryItemToControlByName('cbEncodeWithWindows10Mangling');
                 LoadRegistryItemToControlByName('cbDecodeAllManglingFormats');
                 LoadRegistryItemToControlByName('jqxVersMore_CleanUpIdenticalCb');
                 LoadRegistryItemToControlByName('jqxVersMore_CleanUpDuplicatesOnSourceSideCb');
                 LoadRegistryItemToControlByName('jqxVersMore_RemoveParenthesizedCb');
                 LoadRegistryItemToControlByName('jqxVersMore_RemoveVesioningTagsCb');
                 LoadRegistryItemToControlByName('jqxVersMore_CleanUpAllOlderVersionsCb');
                 LoadRegistryItemToControlByName('jqxVersMore_FilesBackupV4Cb');
                 bTabsVersioningMore = true;
              }

           });
         break;
       case "compression":
         if (!bTabsZip)
         {
           LoadRegistryItemToControlByName('jqxZipping_ZipEachFileCb');
           LoadRegistryItemToControlByName('jqxZipFormatCombo');
           if (!GAllowSZ)
           {
              $("#jqxZipFormatCombo").jqxDropDownList({selectedIndex:0});
              $("#jqxZipFormatCombo").jqxDropDownList('disabled',true);
           }
           LoadRegistryItemToControlByName('jqxZipLevelCombo');
           LoadRegistryItemToControlByName('jqxZipping_UseZipPackagesCb');
           LoadRegistryItemToControlByName('jqxZipping_ZipDirectlyToDestinationCb');
           LoadRegistryItemToControlByName('jqxZipping_UnzipAllfilesCb');
           LoadRegistryItemToControlByName('jqxKeepUnzippedFiles');
           LoadRegistryItemToControlByName('jqxZipping_LimitZipFileSizeCb');
           LoadRegistryItemToControlByName('inptZipping_Limit');
           bTabsZip = true;
         }
         EnableDisableZipTab();
         ZipFormatChange();
         break;

       case "encryption":
         if (!bTabsEncryption)
         {
           LoadRegistryItemToControlByName('jqxZippingEncrypt_EncryptFilesCb');
           LoadRegistryItemToControlByName('jqxZippingEncrypt_Combo');
           LoadRegistryItemToControlByName('jqxZippingEncrypt_DecryptFilesCb');
           LoadRegistryItemToControlByName('jqxZippingEncrypt_Password');

           $("#jqxZippingEncrypt_Confirm").jqxPasswordInput(
               { width: 400, height: 25 });
           $("#jqxZippingEncrypt_Confirm").jqxPasswordInput(
                 'val', $("#jqxZippingEncrypt_Password").jqxPasswordInput('val'));

           LoadRegistryItemToControlByName('jqxZippingEncrypt_FilenameEncryptionCb');
           LoadRegistryItemToControlByName('jqxZippingEncrypt_EncryptExistingNamesCb');
           LoadRegistryItemToControlByName('jqxZippingEncrypt_FoldernameEncryptionCb');
           LoadRegistryItemToControlByName('jqxEncryptPGP');
           LoadRegistryItemToControlByName('jqxDecryptPGP');
           LoadRegistryItemToControlByName('jqxKeepDecryptedPGP');

           $('#PGPPublicKeyButton').jqxButton({theme: GTheme});
           $('#PGPPublicKeyButton').off('click');
           $('#PGPPublicKeyButton').click(
               function()
               {
                  ShowKeyDlg(GPGPPublicKey,false);
               }
               );

           $('#PGPPrivateKeyButton').jqxButton({theme: GTheme});
           $('#PGPPrivateKeyButton').off('click');
           $('#PGPPrivateKeyButton').click(
              function()
              {
                 ShowKeyDlg(GPGPPrivateKey,true);
              }
              );

           EnableDisableEncryptionTab();
           bTabsEncryption = true;
         }
         ZipFormatChange();
         break;

       case "info":
         if (!bTabsInfo)
         {
            $('#detailsButton').jqxButton({theme: GTheme});
            $('#detailsButton').on('click',ShowProfileDetails);
            LoadRegistryItemToControlByName('inptNotes');
            bTabsInfo=true;
         }
         break;

       default:
          alert("Unknown page "+CategoryName);
       }
     }
 });

  $('#jqxMainCategoryTabs').on('selecting', function (event)
  { // Some code here.
     var ItemIndex = event.args.item;
     if ((ItemIndex == 4) && (bFoldersTabCreated == false))
     {
         //Folders
         LoadRegistryItemToControlByName('jqxFolders_CreateEmptyFolders');
         LoadRegistryItemToControlByName('jqxFolders_UseIntermediateLocationCb');
         LoadRegistryItemToControlByName('jqxFolders_RemoveEmptiedFolders');
         LoadRegistryItemToControlByName('jqxFolders_OnRightSideCreateFolderEachTime');
         LoadRegistryItemToControlByName('jqxFolders_IncludeTimeOfDay');

         LoadRegistryItemToControlByName('jqxFolders_FlatRightSide');
         LoadRegistryItemToControlByName('inptMaxSubfolderLevels');
         LoadRegistryItemToControlByName('jqxFolders_CopyLatestFileIfExists');
         LoadRegistryItemToControlByName('jqxFolders_FlatRightAddTimestampsForDupes');
         LoadRegistryItemToControlByName('jqxFolders_EnsureFolderTimestamps');
         LoadRegistryItemToControlByName('jqxDontDeleteFolders');
         LoadRegistryItemToControlByName('cbTouchLeftParents');
         LoadRegistryItemToControlByName('cbTouchRightParents');
         LoadRegistryItemToControlByName('jqxFolders_ScanAllDestinationFoldersToFindMovedFiles');

         if (GisSyncoveryWindows)
            LoadRegistryItemToControlByName('jqxFolders_CreateFolderSymlinksOnly');
         else
            $('#jqxFolders_CreateFolderSymlinksOnly').css({"display":"none"});

         EnableDisableFolders();
         bFoldersTabCreated = true;

     }
     if ((ItemIndex == 5) && (bJobTabCreated == false) )
     {
        //Job
        LoadRegistryItemToControlByName('jqxJob_ExecuteCommand');
        LoadRegistryItemToControlByName('jqxJob_ShowCheckboxesInPreview');
        LoadRegistryItemToControlByName('jqxJob_OverrideEmailSettings');
        LoadRegistryItemToControlByName('jqxJob_CheckFreeSpaceBeforeCopying');
        LoadRegistryItemToControlByName('jqxJob_RunAsUser');
        LoadRegistryItemToControlByName('jqxJob_IgnoreInternetConnectivityCheck');
        LoadRegistryItemToControlByName('jqxJob_NetworkConnections');
        LoadRegistryItemToControlByName('jqxJob_UseExternalCopyingTool');
        LoadRegistryItemToControlByName('jqxJob_RunOnlyIfNeitherSideEmpty');
        LoadRegistryItemToControlByName('jqxJob_WhenRunViaScheduler');
        LoadRegistryItemToControlByName('jqxJob_WhenRunManuallyUnattended');
        LoadRegistryItemToControlByName('jqxJob_WhenRunManuallyAttended');

        $("#Job_Threads_Default_Radio_Mode").jqxRadioButton({groupName :"JobFilesThreadsRadiogroupWidget"});
        $("#Job_Threads_Custom_Radio_Mode").jqxRadioButton({groupName :"JobFilesThreadsRadiogroupWidget"});

        LoadRegistryItemToControlByName('JobFilesThreadsRadiogroupWidget');
        LoadRegistryItemToControlByName('inptScanningThreads');

        $("#jqxPascalScriptCb").jqxCheckBox({ width: 250, height: 25, checked : GUsePascalScript });
        $("#jqxPascalScriptCb").on('click', ShowPascalScriptDlg );
        bJobTabCreated = true;
                     
     }
  });


 //Profile settings Dialog
   $('#jqxProfileEditorForm').jqxWindow({ maxWidth: GProfileSettingsDialogWidth,  width: GProfileSettingsDialogWidth,
     maxHeight: GProfileSettingsDialogHeight, height: GProfileSettingsDialogHeight, autoOpen: false, isModal: true,
     theme: GTheme, animationType: 'slide', draggable: true });


   LoadRegistryListToVariables(GProfileEditorRegistryList);

   LoadRegistryItemToControlByName('inptProfileName');
   LoadRegistryItemToControlByName('inptProfilePriority');

   if (GShowPriority)
   {
      $('#inptProfilePriority').css({"display":"block"});
      $('#lbPriority').css({"display":"block"});
   }
   else
   {
      $('#inptProfilePriority').css({"display":"none"});
      $('#lbPriority').css({"display":"none"});
   }

   var lwidth = 440;
   var rwidth = 440;

   $("#inptLeftHandSide").jqxInput({ width : lwidth, height : 25});
   $("#inptLeftHandSide").jqxInput( 'val', GLeftStoredPath )
   $("#inptRightHandSide").jqxInput({ width : rwidth, height : 25 });
   $("#inptRightHandSide").jqxInput( 'val', GRightStoredPath );

   LoadRegistryItemToControlByName('cbAdditionalDests');
   GAdditionalDests=GetCheckBoxValue('cbAdditionalDests');

   if (GisSyncoveryDebug) console.log("Creating jqxLeftToRightCb");
   // console.trace("Stack trace:");
   LoadRegistryItemToControlByName('jqxLeftToRightCb');
   LoadRegistryItemToControlByName('jqxRightToLeftCb');

   $("#NoneMode").jqxRadioButton({groupName :"IncludeSubfoldersWidget"});
   $("#AllMode").jqxRadioButton({groupName :"IncludeSubfoldersWidget"});
   $("#SelectedMode").jqxRadioButton({groupName :"IncludeSubfoldersWidget"});
   LoadRegistryItemToControlByName('IncludeSubfoldersWidget');

   $("#Standard_Copying_Mode").jqxRadioButton({groupName :"SyncOperationModeWidget"});

   $("#Standard_Copying_Mode").on('change', function (event) {
               
     if (event.args.checked)
     {
       do_sync_operationmode_description("Standard_Copying_Mode");
       GMrr_ExactMirrorDeletesCb = false;
       GMrr_ExactMirrorLeaveAlone = true;
       GMrr_ExactMirrorOverwritesNewerFiles = false;
       GMrr_ExactMirrorCancelIfNewer = false;
       GMrr_ExactMirrorReverseIfNewer = false;
       GMrr_ExactMirrorFallback = false;
       GMrr_DeleteNonMatchingFiltersCb = false;
       GMrr_DeleteDeselectedCb = false;
       GMrr_DeleteNonMatchingMasksCb = false;
       syncOperationModeEnableDisable();
     }
    } );

   $("#SmartTracking_Mode").jqxRadioButton({groupName :"SyncOperationModeWidget"});

   $("#SmartTracking_Mode").on('change', function (event) {
     if (event.args.checked)
     {
       do_sync_operationmode_description("SmartTracking_Mode");
       GMrr_ExactMirrorDeletesCb = false;
       GMrr_ExactMirrorLeaveAlone = true;
       GMrr_ExactMirrorOverwritesNewerFiles = false;
       GMrr_ExactMirrorCancelIfNewer = false;
       GMrr_ExactMirrorReverseIfNewer = false;
       GMrr_ExactMirrorFallback = false;
       GMrr_DeleteNonMatchingFiltersCb = false;
       GMrr_DeleteDeselectedCb = false;
       GMrr_DeleteNonMatchingMasksCb = false;
       syncOperationModeEnableDisable();
     }
   });

   $("#Exact_Mirror_Mode").jqxRadioButton({groupName :"SyncOperationModeWidget"});
   $("#Exact_Mirror_Mode").on('change', function (event) {
     if (event.args.checked)
 {
       do_sync_operationmode_description("Exact_Mirror_Mode");
       if (!GMrr_ExactMirrorDeletesCb && !GMrr_ExactMirrorOverwritesNewerFiles &&
           !GMrr_ExactMirrorCancelIfNewer && !GMrr_ExactMirrorReverseIfNewer &&
           !GMrr_DeleteNonMatchingFiltersCb && !GMrr_DeleteDeselectedCb && !GMrr_DeleteNonMatchingMasksCb)
       {
          // default values!!
          GMrr_ExactMirrorDeletesCb = true;
          GMrr_ExactMirrorOverwritesNewerFiles = true;
          GMrr_ExactMirrorLeaveAlone = false;
          GMrr_ExactMirrorCancelIfNewer = false;
          GMrr_ExactMirrorReverseIfNewer = false;
          GMrr_ExactMirrorFallback = false;
          GMrr_DelayDeletionsCb = false;
          GMrr_OVDelayDeletionsCb = false;
       }
       syncOperationModeEnableDisable();
  }
    });

   $("#Move_Files_Mode").jqxRadioButton({groupName :"SyncOperationModeWidget"});
              
   $("#Move_Files_Mode").on('change', function (event) {
     if (event.args.checked)
     {
       do_sync_operationmode_description("Move_Files_Mode");
       GMrr_ExactMirrorDeletesCb = false;
       GMrr_ExactMirrorOverwritesNewerFiles = false;
       GMrr_ExactMirrorLeaveAlone = true;
       GMrr_ExactMirrorCancelIfNewer = false;
       GMrr_ExactMirrorReverseIfNewer = false;
       GMrr_ExactMirrorFallback = false;
       GMrr_DeleteNonMatchingFiltersCb = false;
       GMrr_DeleteDeselectedCb = false;
       GMrr_DeleteNonMatchingMasksCb = false;
       syncOperationModeEnableDisable();
     }
   });

   LoadRegistryItemToControlByName('CaseSensitive');

 /*
   LoadRegistryItemToControl(GRadioButtonsRegistryList[3]); //Standard_Copying_Mode
   LoadRegistryItemToControl(GRadioButtonsRegistryList[4]); //SmartTracking_Mode
   LoadRegistryItemToControl(GRadioButtonsRegistryList[5]); //Exact_Mirror_Mode
   LoadRegistryItemToControl(GRadioButtonsRegistryList[6]); //Move_Files_Mode
 */
   LoadRegistryItemToControlByName('SyncOperationModeWidget');

   syncOperationModeEnableDisable();


function AssignLeftPath()
{
  var LNewPath = $("#inptLeftHandSide").jqxInput( 'val' );

  GLeftStoredPath = LNewPath;

  GLeftStoredPath = $("#inptLeftHandSide").jqxInput( 'val' );
}

function AssignRightPath()
{
  var LNewPath = $("#inptRightHandSide").jqxInput( 'val' );

  GRightStoredPath =  LNewPath;

  GRightStoredPath =  $("#inptRightHandSide").jqxInput( 'val' );
}

if (GisSyncoveryDebug) console.log("Initializing Main Form, GProfileEditorInitialized: "+GProfileEditorInitialized);
// console.trace("Stack");

function fixJqxButtonLabelTop(btnId, expectedText, newTopPx) {
  setTimeout(() => {
    $(`${btnId} span`).each(function () {
      const $span = $(this);
      if ($span.css("position") === "absolute" &&
          $span.text().trim() === expectedText) {
        $span.css("top", newTopPx);
      }
    });
  }, 0);
}

function fixJqxButtonLabelTopAndMargin(btnId, expectedText, newTopPx, newImageLeftPx = null)
{
  setTimeout(() => {
    if (GisSyncoveryDebug) console.log("fixJqxButtonLabelTopAndMargin("+btnId+","+expectedText+","+newTopPx+","+newImageLeftPx);
    const $btn = $(btnId);
    $btn.find("span").each(function () {
      const $span = $(this);
      if ($span.css("position") === "absolute" &&
          $span.text().trim() === expectedText) {
        $span.css({
          top: newTopPx,
          "margin-left": "6px"
        });
      }
    });

    /*
    does not work
    if (newImageLeftPx !== null)
    {
      $btn.find("img").each(function () {
        const $img = $(this);
        if (GisSyncoveryDebug) console.log("processing img:",$img);
        if ($img.css("position") === "absolute")
        {
          if (GisSyncoveryDebug) console.log("Style is",$img[0].style);
          if (GisSyncoveryDebug) console.log("Setting left to ",newImageLeftPx);
          $img[0].style.left = newImageLeftPx;
          if (GisSyncoveryDebug) console.log("img is now:",$img);
          if (GisSyncoveryDebug) console.log("Style is now:",$img[0].style);
        }
      });
    }
    */
  }, 0);
}


if (!GProfileEditorInitialized)
{
   $("#infoButton1").jqxButton({ theme: GTheme, height: GBtnHeight, width: 100, imgSrc:"images/folder.png",imgPosition:"left",textPosition: "left",textImageRelation: "imageBeforeText"});
   $('#infoButton1').off('click');
   $('#infoButton1').click(function ()
   {
     var Lleftpath=$("#inptLeftHandSide").jqxInput('val');

     if ((Lleftpath!='') && (Lleftpath.indexOf("://")>=0))
     {
        GLeftStoredPath = Lleftpath;
        PostProfileEditor("***BROWSEDUMMY***", "Browse",
            function()
            {
               InitDirTreeSelectForm($("#inptLeftHandSide"), AssignLeftPath, "left");
            });
     }
     else
     {
        InitDirTreeSelectForm($("#inptLeftHandSide"), AssignLeftPath, "left");
     }
   });

   fixJqxButtonLabelTopAndMargin("#infoButton1", "Browse...", "9px", "10px");

   $("#infoButton2").jqxButton({ theme: GTheme, height: GBtnHeight, width: 100, imgSrc:"images/folder.png",imgPosition:"left",textPosition: "left",textImageRelation: "imageBeforeText"});
   $('#infoButton2').off('click');
   $('#infoButton2').click(function ()
   {
      var Lrightpath=$("#inptRightHandSide").jqxInput('val');
      if ((Lrightpath!='') && (Lrightpath.indexOf("://")>=0))
      {
         GRightStoredPath = Lrightpath;
         PostProfileEditor("***BROWSEDUMMY***", "Browse",
            function()
            {
               InitDirTreeSelectForm($("#inptRightHandSide"), AssignRightPath, "right");
            });
      }
      else
         InitDirTreeSelectForm($("#inptRightHandSide"), AssignRightPath, "right");
   });
   fixJqxButtonLabelTopAndMargin("#infoButton2", "Browse...", "9px");

   if (GisSyncoveryWindows)
      $('#smbBtnLeft').css({"display":"none"});
   else
   {
     $("#smbBtnLeft").jqxButton({ theme: GTheme, height: GBtnHeight, width: 80, imgSrc:"images/protocols/smb.png",imgPosition:"left",textPosition: "left",textImageRelation: "imageBeforeText"});
     $('#smbBtnLeft').off('click');
     $('#smbBtnLeft').click(function ()
     {
        GLeftProtocolName = "SMB";
        DoSMBDialog(GSelectedProfileName,false,$("#inptLeftHandSide"),GLeftStoredPath);
     });
   }

   $("#intrntBtnLeft").jqxButton({ theme: GTheme, height: GBtnHeight, width: 90, imgSrc:"images/internet.png",imgPosition:"left",textPosition: "left",textImageRelation: "imageBeforeText"});
   $('#intrntBtnLeft').off('click');
   $('#intrntBtnLeft').click(function ()
   {
       if (GLeftProtocolName == "")
       {
           GLeftProtocolName = "FTP";
           //document.getElementById("error_message").innerHTML = "GLeftProtocolName is empty";
           //return;
       }
       DoInternetSettingsDialog( GSelectedProfileName,
                                 GInternetProtocolSetLEFTRegistryList,
                                 "left",
                                 GLeftProtocolName,
                                 $("#inptLeftHandSide"),
                                 GLeftStoredPath,
                                 GLeftUsername,
                                 GLeftPassword,
                                 false,
                                 $('#jqxProfileEditorForm'));
   });
   fixJqxButtonLabelTopAndMargin("#intrntBtnLeft", "Internet...", "9px");

   if (GisSyncoveryWindows)
      $('#smbBtnRight').css({"display":"none"});
   else
   {
     $("#smbBtnRight").jqxButton({ theme: GTheme, height: GBtnHeight, width: 80, imgSrc:"images/protocols/smb.png",imgPosition:"left",textPosition: "left",textImageRelation: "imageBeforeText"});
     $('#smbBtnRight').off('click');
     $('#smbBtnRight').click(function ()
     {
        GLeftProtocolName = "SMB";
        DoSMBDialog(GSelectedProfileName,true,$("#inptRightHandSide"),GRightStoredPath);
     });
   }

   $("#intrntBtnRight").jqxButton({ theme: GTheme, height: GBtnHeight, width: 90, imgSrc:"images/internet.png",imgPosition:"left",textPosition: "left",textImageRelation: "imageBeforeText"});
   $('#intrntBtnRight').off('click');
   $('#intrntBtnRight').click(function ()
   {
       if (GRightProtocolName == "")
       {
           GRightProtocolName = "FTP";
       }

       DoInternetSettingsDialog( GSelectedProfileName, GInternetProtocolSetRIGHTRegistryList, "right",
                                 GRightProtocolName, $("#inptRightHandSide"),
                                 GRightStoredPath,
                                 GRightUsername,
                                 GRightPassword,
                                 false,
                                 $('#jqxProfileEditorForm'));
   });
   fixJqxButtonLabelTopAndMargin("#intrntBtnRight", "Internet...", "9px");

   $("#btnChooseFolderFiles").jqxButton({ theme: GTheme, height: GBtnHeight, width: GChooseFolderFilesBtnWidth });
   $('#btnChooseFolderFiles').off('click');
   $('#btnChooseFolderFiles').click(function ()
   {
         PostProfileEditor("***BROWSEDUMMY***", "Browse",
            function()
            {
               DoChooseFolderFilesDlg(GSelectedProfileName);
            });
   });
}

function ShowSmartTrackingSettingsDlg()
{
   $('#jqxSmartTrackingSettingsDlg').jqxWindow({ maxWidth: 720,  width:720, maxHeight:560, height:560, autoOpen: false, isModal: true,
   theme: GTheme, animationType: 'slide', draggable: true });

   $('#jqxSmartTracking_SettingsTabs').jqxTabs({ width: 690, height: 370});

   $("#Smt_Moved_Off_Mode").jqxRadioButton({groupName :"TabMoved"});
   $("#Smt_Moved_Fully_Automatic_Mode").jqxRadioButton({groupName :"TabMoved"});
   $("#Smt_Moved_Adjust_On_Left_Mode").jqxRadioButton({groupName :"TabMoved"});
   $("#Smt_Moved_Adjust_On_Right_Mode").jqxRadioButton({groupName :"TabMoved"});

   SetSmartTrackingGlobalVariablesFromFilesTab();

   SetRadioGroupChecked( GSmartTrackingMoveSettingsWidget,   $("#Smt_Moved_Off_Mode"),  $("#Smt_Moved_Fully_Automatic_Mode"), $("#Smt_Moved_Adjust_On_Left_Mode"), $("#Smt_Moved_Adjust_On_Right_Mode"), null, null );

   $("#Smt_Deleted_Copy_Back_Mode").jqxRadioButton({groupName :"TabDeleted"});
   $("#Smt_Deleted_Ignore_Mode").jqxRadioButton({groupName :"TabDeleted"});
   $("#Smt_Deleted_Move_IntoFolder_Mode").jqxRadioButton({groupName :"TabDeleted"});
   $("#Smt_Deleted_DeletePermamently_Mode").jqxRadioButton({groupName :"TabDeleted"});

   if (GbTabFilesDeletions) // if tab created
   {
      if ($("#jqxFilesDeletions_MoveFilesToSFolder").jqxCheckBox('checked'))
         GSmartTrackingDeletedSettingsWidget = "Smt_Deleted_Move_IntoFolder_Mode";
      else
         if (GSmartTrackingDeletedSettingsWidget=="Smt_Deleted_Move_IntoFolder_Mode")
            GSmartTrackingDeletedSettingsWidget="";
   }

   if (GSmartTrackingDeletedSettingsWidget=="")
      GSmartTrackingDeletedSettingsWidget = "Smt_Deleted_Ignore_Mode";
   //alert("Setting deleted radio to "+GSmartTrackingDeletedSettingsWidget);
   SetRadioGroupChecked( GSmartTrackingDeletedSettingsWidget,   $("#Smt_Deleted_Copy_Back_Mode"),  $("#Smt_Deleted_Ignore_Mode"), $("#Smt_Deleted_Move_IntoFolder_Mode"), $("#Smt_Deleted_DeletePermamently_Mode"), null, null );
                
   $("#Smt_Confl_Copy_Latest_Mode").jqxRadioButton({groupName :"Panel1"});
   $("#Smt_Confl_DoNothing_Mode").jqxRadioButton({groupName :"Panel1"});
   $("#Smt_Confl_AlwaysCopyLeftToRight_Mode").jqxRadioButton({groupName :"Panel1"});
   $("#Smt_Confl_AlwaysCopyRightToLeft_Mode").jqxRadioButton({groupName :"Panel1"});
   $("#Smt_Confl_Rename_Mode").jqxRadioButton({groupName :"Panel1"});
   $("#Smt_Confl_Prompt_Mode").jqxRadioButton({groupName :"Panel1"});

   if (GSmartTrackingConflictingSettingsWidget=="")
      GSmartTrackingConflictingSettingsWidget = "Smt_Confl_DoNothing_Mode";
   //alert("Setting Conflict radio to "+GSmartTrackingConflictingSettingsWidget);
   SetRadioGroupChecked( GSmartTrackingConflictingSettingsWidget,   $("#Smt_Confl_Copy_Latest_Mode"),  $("#Smt_Confl_DoNothing_Mode"), $("#Smt_Confl_AlwaysCopyLeftToRight_Mode"), $("#Smt_Confl_AlwaysCopyRightToLeft_Mode"), $("#Smt_Confl_Rename_Mode"), $("#Smt_Confl_Prompt_Mode") );

   $("#Smt_Confl_UseNumbers_Mode").jqxRadioButton({groupName :"Panel2" });
   $("#Smt_Confl_Replace_Mode").jqxRadioButton({groupName :"Panel2" });
   if (GSmartTrackingConflictsIfExistsAddNumberWidget=="")
      GSmartTrackingConflictsIfExistsAddNumberWidget="Smt_Confl_UseNumbers_Mode";
   SetRadioGroupChecked( GSmartTrackingConflictsIfExistsAddNumberWidget,   $("#Smt_Confl_UseNumbers_Mode"),  $("#Smt_Confl_Replace_Mode"), null, null, null, null );

   $("#inpt_Smt_DeletedFilesIntoFolderL").jqxInput({ width : 530, height : 25 });
   $("#inpt_Smt_DeletedFilesIntoFolderL").jqxInput('val', GMoveDeletedFilesIntoFolderL);

   $("#inpt_Smt_DeletedFilesIntoFolderR").jqxInput({ width : 530, height : 25 });
   $("#inpt_Smt_DeletedFilesIntoFolderR").jqxInput('val', GMoveDeletedFilesIntoFolderR);

   $("#jqxSmt_DetectUnchangedLeftCb").jqxCheckBox({ width: 450, height: 25, checked : GSmt_DetectUnchangedLeftCb });
   $("#jqxSmt_DetectUnchangedRightCb").jqxCheckBox({ width: 450, height: 25, checked : GSmt_DetectUnchangedRightCb });
   $("#jqxSmt_DetectServerSizeModsCb").jqxCheckBox({ width: 550, height: 25, checked : GSmt_DetectServerSizeModsCb });

   $("#jqxSmt_BothNewConflictCb").jqxCheckBox({ width: 650, height: 25, checked : GSmt_BothNewConflictCb });
   $("#jqxSmt_BothNewConflictCheckArchiveFlagAndTimestampCb").jqxCheckBox({ width: 650, height: 25, checked : GSmt_BothNewConflictCheckArchiveFlagAndTimestampCb });

   if (!GSmt_ConflictsAddNumberCb && !GSmt_ConflictsAddUserCb &&
       !GSmt_ConflictsAddTimeCb && !GSmt_ConflictsAddDollarCb)
      GSmt_ConflictsAddNumberCb = true;

   $("#jqxSmt_ConflictsAddNumberCb").jqxCheckBox({ width: 160, height: 25, checked : GSmt_ConflictsAddNumberCb });
   $("#jqxSmt_ConflictsAddUserCb").jqxCheckBox({ width: 110, height: 25, checked : GSmt_ConflictsAddUserCb });
   $("#jqxSmt_ConflictsAddTimeCb").jqxCheckBox({ width: 150, height: 25, checked : GSmt_ConflictsAddTimeCb });
   $("#jqxSmt_ConflictsAddDollarCb").jqxCheckBox({ width: 60, height: 25, checked : GSmt_ConflictsAddDollarCb });


   $("#btn_Smt_DirSelectL").jqxButton({ theme: GTheme, height: GBtnHeight, width: GBtnWidth });
   $('#btn_Smt_DirSelectL').off('click');
   $('#btn_Smt_DirSelectL').click(function () {
     InitDirTreeSelectForm($("#inpt_Smt_DeletedFilesIntoFolderL"), null, "left");
   });

   $("#btn_Smt_DirSelectR").jqxButton({ theme: GTheme, height: GBtnHeight, width: GBtnWidth });
   $('#btn_Smt_DirSelectR').off('click');
   $('#btn_Smt_DirSelectR').click(function () {
     InitDirTreeSelectForm($("#inpt_Smt_DeletedFilesIntoFolderR"), null, "right");
   });

   $('#SmtSet_OK_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
   $('#SmtSet_OK_btn').off('click');
   $('#SmtSet_OK_btn').click(function () {
                
      GSmartTrackingMoveSettingsWidget = GetCheckedRadiobuttonName(  $("#Smt_Moved_Off_Mode"),  $("#Smt_Moved_Fully_Automatic_Mode"), $("#Smt_Moved_Adjust_On_Left_Mode"), $("#Smt_Moved_Adjust_On_Right_Mode"), null, null );

      GSmartTrackingDeletedSettingsWidget = GetCheckedRadiobuttonName( $("#Smt_Deleted_Copy_Back_Mode"),  $("#Smt_Deleted_Ignore_Mode"), $("#Smt_Deleted_Move_IntoFolder_Mode"), $("#Smt_Deleted_DeletePermamently_Mode"), null, null );
      GSmartTrackingConflictingSettingsWidget = GetCheckedRadiobuttonName( $("#Smt_Confl_Copy_Latest_Mode"),  $("#Smt_Confl_DoNothing_Mode"), $("#Smt_Confl_AlwaysCopyLeftToRight_Mode"), $("#Smt_Confl_AlwaysCopyRightToLeft_Mode"), $("#Smt_Confl_Rename_Mode"), $("#Smt_Confl_Prompt_Mode") );
      GSmt_DetectUnchangedLeftCb = $("#jqxSmt_DetectUnchangedLeftCb").jqxCheckBox('val');
      GSmt_DetectUnchangedRightCb = $("#jqxSmt_DetectUnchangedRightCb").jqxCheckBox('val');
      GSmt_DetectServerSizeModsCb = $("#jqxSmt_DetectServerSizeModsCb").jqxCheckBox('val');
      GSmt_BothNewConflictCb = $("#jqxSmt_BothNewConflictCb").jqxCheckBox('val');
      GSmt_BothNewConflictCheckArchiveFlagAndTimestampCb = $("#jqxSmt_BothNewConflictCheckArchiveFlagAndTimestampCb").jqxCheckBox('val');
      GSmt_ConflictsAddNumberCb = $("#jqxSmt_ConflictsAddNumberCb").jqxCheckBox('val');

      GSmt_ConflictsAddUserCb = $("#jqxSmt_ConflictsAddUserCb").jqxCheckBox('val');
      GSmt_ConflictsAddTimeCb = $("#jqxSmt_ConflictsAddTimeCb").jqxCheckBox('val');
      GSmt_ConflictsAddDollarCb = $("#jqxSmt_ConflictsAddDollarCb").jqxCheckBox('val');
      GSmartTrackingConflictsIfExistsAddNumberWidget = GetCheckedRadiobuttonName( $("#Smt_Confl_UseNumbers_Mode"),  $("#Smt_Confl_Replace_Mode"), null, null, null, null );

      GMoveDeletedFilesIntoFolderL = $("#inpt_Smt_DeletedFilesIntoFolderL").jqxInput('val');
      GMoveDeletedFilesIntoFolderR = $("#inpt_Smt_DeletedFilesIntoFolderR").jqxInput('val');

      SetFilesTabFromSmartTrackingGlobalVariables();

      SetFilesDeletionsTabFromSmartTrackingGlobalVariables();

      $('#jqxSmartTrackingSettingsDlg').jqxWindow('close');
    });


   $('#SmtSet_Cancel_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
   $('#SmtSet_Cancel_btn').off('click');
   $('#SmtSet_Cancel_btn').click(function () {

      $('#jqxSmartTrackingSettingsDlg').jqxWindow('close');
   });

   $('#jqxSmartTrackingSettingsDlg').jqxWindow('open');
}

function ShowExactMirrorSettingsDlg()
{
  $('#jqxExactMirrorSettingsDlg').jqxWindow({ maxWidth: 810,  width:700, maxHeight:650, height:650, autoOpen: false, isModal: true,
            theme: GTheme, animationType: 'slide' , draggable: true});
  $("#jqxMrr_ExactMirrorDeletesCb").jqxCheckBox({ width: 500, height: 25, checked : GMrr_ExactMirrorDeletesCb });

  $("#jqxMrr_ExactMirrorLeaveAlone").jqxRadioButton({ width: 500, height: 25, checked : GMrr_ExactMirrorLeaveAlone });
  $("#jqxMrr_ExactMirrorOverwritesNewerFiles").jqxRadioButton({ width: 500, height: 25, checked : GMrr_ExactMirrorOverwritesNewerFiles });
  $("#jqxMrr_ExactMirrorCancelIfNewer").jqxRadioButton({ width: 500, height: 25, checked : GMrr_ExactMirrorCancelIfNewer });
  $("#jqxMrr_ExactMirrorReverseIfNewer").jqxRadioButton({ width: 500, height: 25, checked : GMrr_ExactMirrorReverseIfNewer });
  $("#jqxMrr_ExactMirrorFallback").jqxCheckBox({ width: 500, height: 25, checked : GMrr_ExactMirrorFallback });

  $("#jqxMrr_DelayDeletionsCb").jqxCheckBox({ width: 500, height: 25, checked : GMrr_DelayDeletionsCb});

  $("#jqxMrr_DeleteNonMatchingFiltersCb").jqxCheckBox({ width: 500, height: 25, checked : GMrr_DeleteNonMatchingFiltersCb });
  $("#jqxMrr_DeleteDeselectedCb").jqxCheckBox({ width: 500, height: 25, checked : GMrr_DeleteDeselectedCb });
  $("#jqxMrr_DeleteNonMatchingMasksCb").jqxCheckBox({ width: 500, height: 25, checked : GMrr_DeleteNonMatchingMasksCb });


  $("#inptMrr_DelayDelDays").jqxNumberInput( { width: 30, height: 25, inputMode: 'simple', decimalDigits: 0 } );//, theme:'shinyblack'
  $("#inptMrr_DelayDelDays").jqxNumberInput( 'val', GMrr_DelayDelDays );

  $("#inptMrr_DelayDelHours").jqxNumberInput( { width: 30, height: 25, inputMode: 'simple', decimalDigits: 0 } );//, theme:'shinyblack'
  $("#inptMrr_DelayDelHours").jqxNumberInput( 'val', GMrr_DelayDelHours );

  $("#inptMrr_DelayDelMinutes").jqxNumberInput( { width: 30, height: 25, inputMode: 'simple', decimalDigits: 0 } );//, theme:'shinyblack'
  $("#inptMrr_DelayDelMinutes").jqxNumberInput( 'val', GMrr_DelayDelMinutes );

  $("#jqxMrr_OVDelayDeletionsCb").jqxCheckBox({ width: 500, height: 25, checked : GMrr_OVDelayDeletionsCb });//, theme:'shinyblack'

  $("#inptMrr_OVDelayDelDays").jqxNumberInput( { width: 30, height: 25, inputMode: 'simple', decimalDigits: 0 } );//, theme:'shinyblack'
  $("#inptMrr_OVDelayDelDays").jqxNumberInput( 'val', GMrr_OVDelayDelDays );

  $("#inptMrr_OVDelayDelHours").jqxNumberInput( { width: 30, height: 25, inputMode: 'simple', decimalDigits: 0 } );//, theme:'shinyblack'
  $("#inptMrr_OVDelayDelHours").jqxNumberInput( 'val', GMrr_OVDelayDelHours );

  $("#inptMrr_OVDelayDelMinutes").jqxNumberInput( { width: 30, height: 25, inputMode: 'simple', decimalDigits: 0 } );//, theme:'shinyblack'
  $("#inptMrr_OVDelayDelMinutes").jqxNumberInput( 'val', GMrr_OVDelayDelMinutes );


  

    $('#ExactMirror_OK_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
    $('#ExactMirror_OK_btn').off('click');
    $('#ExactMirror_OK_btn').click(function () {
       GMrr_ExactMirrorDeletesCb = $("#jqxMrr_ExactMirrorDeletesCb").jqxCheckBox('val');

       GMrr_ExactMirrorLeaveAlone = $("#jqxMrr_ExactMirrorLeaveAlone").jqxRadioButton('val');
       GMrr_ExactMirrorOverwritesNewerFiles = $("#jqxMrr_ExactMirrorOverwritesNewerFiles").jqxRadioButton('val');
       GMrr_ExactMirrorCancelIfNewer = $("#jqxMrr_ExactMirrorCancelIfNewer").jqxRadioButton('val');
       GMrr_ExactMirrorReverseIfNewer = $("#jqxMrr_ExactMirrorReverseIfNewer").jqxRadioButton('val');
       GMrr_ExactMirrorFallback = $("#jqxMrr_ExactMirrorFallback").jqxCheckBox('val');

       GMrr_DelayDeletionsCb = $("#jqxMrr_DelayDeletionsCb").jqxCheckBox('val');
       GMrr_DeleteNonMatchingFiltersCb = $("#jqxMrr_DeleteNonMatchingFiltersCb").jqxCheckBox('val');
       GMrr_DeleteDeselectedCb = $("#jqxMrr_DeleteDeselectedCb").jqxCheckBox('val');
       GMrr_DeleteNonMatchingMasksCb = $("#jqxMrr_DeleteNonMatchingMasksCb").jqxCheckBox('val');
       GMrr_DelayDelDays = $("#inptMrr_DelayDelDays").jqxNumberInput( 'val' );
       GMrr_DelayDelHours = $("#inptMrr_DelayDelHours").jqxNumberInput( 'val' );
       GMrr_DelayDelMinutes = $("#inptMrr_DelayDelMinutes").jqxNumberInput( 'val' );
       GMrr_OVDelayDelDays = $("#inptMrr_OVDelayDelDays").jqxNumberInput( 'val' );
       GMrr_OVDelayDelHours = $("#inptMrr_OVDelayDelHours").jqxNumberInput( 'val' );
       GMrr_OVDelayDelMinutes = $("#inptMrr_OVDelayDelMinutes").jqxNumberInput( 'val' );
       GMrr_OVDelayDeletionsCb = $("#jqxMrr_OVDelayDeletionsCb").jqxCheckBox( 'val' );
       $('#jqxExactMirrorSettingsDlg').jqxWindow('close');
    });


    $('#ExactMirror_Cancel_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
    $('#ExactMirror_Cancel_btn').off('click');
    $('#ExactMirror_Cancel_btn').click(function () {

       $('#jqxExactMirrorSettingsDlg').jqxWindow('close');
    });

  $('#jqxExactMirrorSettingsDlg').jqxWindow('open');
}

function ShowMoveSettingsDlg()
{
   $('#jqxMoveSettingsDlg').jqxWindow({ maxWidth: 500,  width:500, maxHeight:420, height:420, autoOpen: false, isModal: true,
    theme: GTheme, animationType: 'slide', draggable: true });

    $("#mmMoveNormal_Mode").jqxRadioButton({groupName :"Panel1"});
    $("#mmOverwriteDest_Mode").jqxRadioButton({groupName :"Panel1"});
    $("#mmRenameSource_Mode").jqxRadioButton({groupName :"Panel1"});
    $("#mmDeleteIdenticalSource_Mode").jqxRadioButton({groupName :"Panel1"});
                
                  
    SetRadioGroupChecked( GMoveFilesMode,   $("#mmMoveNormal_Mode"),  $("#mmOverwriteDest_Mode"), $("#mmRenameSource_Mode"), $("#mmDeleteIdenticalSource_Mode"), null, null );
                                                

    $("#jqxMove_MoveByCopyingCb").jqxCheckBox({ width: 350, height: 25, checked : GMove_MoveByCopyingCb });
              

    $('#MoveDlg_OK_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
    $('#MoveDlg_OK_btn').off('click');
    $('#MoveDlg_OK_btn').click(function () {

       GMove_MoveByCopyingCb = $("#jqxMove_MoveByCopyingCb").jqxCheckBox( 'val' );
       GMoveFilesMode = GetCheckedRadiobuttonName( $("#mmMoveNormal_Mode"),  $("#mmOverwriteDest_Mode"), $("#mmRenameSource_Mode"), $("#mmDeleteIdenticalSource_Mode"), null, null );
       $('#jqxMoveSettingsDlg').jqxWindow('close');
    });


    $('#MoveDlg_Cancel_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
    $('#MoveDlg_Cancel_btn').off('click');
    $('#MoveDlg_Cancel_btn').click(function () {

       $('#jqxMoveSettingsDlg').jqxWindow('close');
    });
             
   $('#jqxMoveSettingsDlg').jqxWindow('open');
}

$("#CopyModeConfigBtn").jqxButton({height: GBtnHeight, width: GBtnWidth2,theme: GTheme});
$('#CopyModeConfigBtn').off('click');
$('#CopyModeConfigBtn').click(function ()
{
  var Option = GetCheckedRadiobuttonName( $("#Standard_Copying_Mode"), $("#SmartTracking_Mode"), $("#Exact_Mirror_Mode"), $("#Move_Files_Mode"), null, null );
  if (Option == "SmartTracking_Mode" )
  {
    if (HTML_SmartTrackingSettingsDlg != '' )
    {
       $("#HTML_SmartTrackingSettingsDlg_div").html( HTML_SmartTrackingSettingsDlg );

        setTimeout(ShowSmartTrackingSettingsDlg, 100);
    }

  }
  else if (Option == "Exact_Mirror_Mode")
  {

    if (HTML_ExactMirrorSettingsDlg != '')
    {
       $("#HTML_ExactMirrorSettingsDlg_div").html( HTML_ExactMirrorSettingsDlg );
       setTimeout(ShowExactMirrorSettingsDlg, 100);
    }
                
  }
  else if ( Option == "Move_Files_Mode")
  {
      if (HTML_MoveSettingsDlg != '' )
      {
         $("#HTML_MoveSettingsDlg_div").html( HTML_MoveSettingsDlg );
          setTimeout(ShowMoveSettingsDlg, 100);
      }
  }
});



//Tab Special

function XAttrDeps()
{
  var LCopyADS = $('#jqxCopyADSCb').jqxCheckBox('checked');

  if (!GisSyncoveryWindows)
     EnableCheckBox("jqxCompareADSCb",LCopyADS);

  EnableCheckBox("cbApplyADSToCompressedFiles",LCopyADS);
  EnableCheckBox("cbPutADSIntoCompressedFiles",LCopyADS);
  EnableCheckBox("cbFolderADSinMetadataFilesLeft",LCopyADS);
  EnableCheckBox("cbFolderADSinMetadataFilesRight",LCopyADS);
}

function ShowSpecial_AlternateDataStreamsDlg()
{
   var thisdlgheight = GisSyncoveryWindows ? 600 : 650;
   $('#jqxSpecial_AlternateDataStreamsDlg').jqxWindow({ maxWidth: 1000,  width:1000, maxHeight:thisdlgheight, height:thisdlgheight, autoOpen: false, isModal: true,
     theme: GTheme, animationType: 'slide', draggable: true });
   $('#jqxSpecial_AlternateDataStreamsTabs').jqxTabs({ width: 950, height: thisdlgheight-180});

   CreateCheckBoxWithValue('jqxCopyADSCb', GCopyADS);
   $("#jqxCopyADSCb").on('click', XAttrDeps );

   CreateCheckBoxWithValue('cbApplyADSToCompressedFiles',GApplyADSToCompressedFiles);
   CreateCheckBoxWithValue('cbPutADSIntoCompressedFiles',GPutADSIntoCompressedFiles);
   CreateCheckBoxWithValue('cbFolderADSinMetadataFilesLeft',GFolderADSinMetadataFilesLeft);
   CreateCheckBoxWithValue('cbFolderADSinMetadataFilesRight',GFolderADSinMetadataFilesRight);

   if (GisSyncoveryWindows)
      CreateCheckBoxWithValue('jqxSplitResourceForksCb',GSplitResourceForksCb);
   else
   {
      CreateCheckBoxWithValue('jqxCompareADSCb', GCompareADS);
      XAttrDeps();
   }

    $('#Special_AlternateDataStreams_OK_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
    $('#Special_AlternateDataStreams_OK_btn').off('click');
    $('#Special_AlternateDataStreams_OK_btn').click(function ()
    {
        GCopyADS = GetCheckBoxValue('jqxCopyADSCb');

        GApplyADSToCompressedFiles = GetCheckBoxValue('cbApplyADSToCompressedFiles');
        GPutADSIntoCompressedFiles = GetCheckBoxValue('cbPutADSIntoCompressedFiles');
        GFolderADSinMetadataFilesLeft = GetCheckBoxValue('cbFolderADSinMetadataFilesLeft');
        GFolderADSinMetadataFilesRight = GetCheckBoxValue('cbFolderADSinMetadataFilesRight');

        if (GisSyncoveryWindows)
           GSplitResourceForksCb = GetCheckBoxValue('jqxSplitResourceForksCb');
        else
           GCompareADS = GetCheckBoxValue('jqxCompareADSCb');

        $('#jqxSpecial_AlternateDataStreamsDlg').jqxWindow('close');
     });

    $('#Special_AlternateDataStreams_Cancel_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
    $('#Special_AlternateDataStreams_Cancel_btn').off('click');
    $('#Special_AlternateDataStreams_Cancel_btn').click(function () {

       $('#jqxSpecial_AlternateDataStreamsDlg').jqxWindow('close');
    });

   $('#jqxSpecial_AlternateDataStreamsDlg').jqxWindow('open'); 
}

                                        
           
//Tab Schedule/RealTime
            
////////////////Real-Time Settings dialog////////////////////////////
function ShowRealTimeSettingsDlg()
{
    $('#jqxRealTimeSettingsDlg').jqxWindow({ maxWidth: 840,  width: 840, maxHeight:600, height:600, autoOpen: false, isModal: true,
       theme: GTheme, animationType: 'slide', draggable: true });
    $('#jqxReal_Tabs').jqxTabs({ width: 790,  height: 400 }); // initTabContent: Real_initWidgets
    if (GisSyncoveryLinux)
       $("#jqxRealDlg_RealTimeSynchronizationCb").html("Use Real-Time Sync (only for some clouds, not local drives - see third tab sheet)");
    $('#jqxRealDlg_RealTimeSynchronizationCb').jqxCheckBox({ width: 600, height: 25, checked : true});
    $('#jqxRunCompletelyOnceCb').jqxCheckBox({ width: 450, height: 25, checked : GRunCompletelyOnceCb });
   
    $('#Process_Each_FileRb').jqxRadioButton({ checked : !GRealtimeFolderMode });
    $('#Process_Complete_FoldersRb').jqxRadioButton({ checked : GRealtimeFolderMode });

    $('#jqxRealDlg_RealTimeDeletionsCb').jqxCheckBox({ width: 450, height: 25, checked : GRealTimeDeletions});
    $('#jqxRealTimeDeletionsSafetyDelay_Input').jqxNumberInput({ width: 40,  height: 25, value: GRealTimeDeletionsSafetyDelay,
          inputMode: 'simple', decimalDigits: 0});
                
    $('#jqxRealDlg_RealTimeRenamesCb').jqxCheckBox({ width: 450, height: 25, checked : GRealTimeRenames });
    $('#jqxRealTimeIgnoreTempFilesCb').jqxCheckBox({ width: 450, height: 25, checked : GRealTimeIgnoreTempFiles});

    $('#jqxRealtimeDelaySeconds_Input').jqxNumberInput({ width: 40,  height: 25, value: GRealtimeDelaySeconds, inputMode: 'simple', decimalDigits: 0});
    $('#jqxFullRunBasedOnItemCount_Input').jqxNumberInput({ width: 40,  height: 25, value: GFullRunBasedOnItemCount, inputMode: 'simple', decimalDigits: 0 });
    $('#jqxFullRunBasedOnTimeSeconds_Input').jqxNumberInput({ width: 40,  height: 25, value: GFullRunBasedOnTimeSeconds, inputMode: 'simple', decimalDigits: 0});
    // new in V9
    $('#cbRealtimeCheckFTPForChanges').jqxCheckBox({ width: 700, height: 25, checked : GRealtimeCheckFTPForChanges });
    $('#cbUseFTPChangesTechniqueForLeftSide').jqxCheckBox({ width: 150, height: 25, checked : GUseFTPChangesTechniqueForLeftSide });
    $('#cbUseFTPChangesTechniqueForRightSide').jqxCheckBox({ width: 150, height: 25, checked : GUseFTPChangesTechniqueForRightSide });
    $('#edFTPChangesCheckIntervalSeconds').jqxNumberInput({ width: 40,  height: 25, value: GFTPChangesCheckIntervalSeconds, inputMode: 'simple', decimalDigits: 0 });

    $('#Real_OK_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
    $('#Real_OK_btn').off('click');
    $('#Real_OK_btn').click(function () {

       $('#jqxRealTimeSynchronizationCb').jqxCheckBox({ checked: $('#jqxRealDlg_RealTimeSynchronizationCb').jqxCheckBox('checked') });

       GRunCompletelyOnceCb = $('#jqxRunCompletelyOnceCb').jqxCheckBox('checked');
       if (GisSyncoveryWindows)
       {
          GRealtimeFolderMode = $('#Process_Complete_FoldersRb').jqxRadioButton('checked');
 	        GRealTimeDeletions = $('#jqxRealDlg_RealTimeDeletionsCb').jqxCheckBox('checked');
	         GRealTimeDeletionsSafetyDelay = $('#jqxRealTimeDeletionsSafetyDelay_Input').jqxNumberInput( 'val' );
	         GRealTimeRenames = $('#jqxRealDlg_RealTimeRenamesCb').jqxCheckBox('checked');
       }
       else
       {
          GRealtimeFolderMode = true;
 	        GRealTimeDeletions = false;
	         GRealTimeDeletionsSafetyDelay = 0;
	         GRealTimeRenames = false;
       }
       GRealTimeIgnoreTempFiles = $('#jqxRealTimeIgnoreTempFilesCb').jqxCheckBox('checked');
       GRealtimeDelaySeconds = $('#jqxRealtimeDelaySeconds_Input').jqxNumberInput( 'val' );
       GFullRunBasedOnItemCount = $('#jqxFullRunBasedOnItemCount_Input').jqxNumberInput( 'val' );
       GFullRunBasedOnTimeSeconds = $('#jqxFullRunBasedOnTimeSeconds_Input').jqxNumberInput( 'val' );

       GRealtimeCheckFTPForChanges = $('#cbRealtimeCheckFTPForChanges').jqxCheckBox('checked');
       GUseFTPChangesTechniqueForLeftSide = $('#cbUseFTPChangesTechniqueForLeftSide').jqxCheckBox('checked');
       GUseFTPChangesTechniqueForRightSide = $('#cbUseFTPChangesTechniqueForRightSide').jqxCheckBox('checked');
       GFTPChangesCheckIntervalSeconds = $('#edFTPChangesCheckIntervalSeconds').jqxNumberInput('val');

       $('#jqxRealTimeSettingsDlg').jqxWindow('close');
    });

    $('#Real_Cancel_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
    $('#Real_Cancel_btn').off('click');
    $('#Real_Cancel_btn').click(function () {
       $('#jqxRealTimeSettingsDlg').jqxWindow('close');
    });

    if (!GisSyncoveryWindows)
    {
       $('#RTOpMode').css({"display":"none"});
       $('#Process_Each_FileRb').css({"display":"none"});
       $('#Process_Complete_FoldersRb').css({"display":"none"});
 	     $('#jqxRealDlg_RealTimeDeletionsCb').css({"display":"none"});
	      $('#jqxRealTimeDeletionsSafetyDelay_Input').css({"display":"none"});
       $('#lbSafetyDelay1').css({"display":"none"});
       $('#lbSafetyDelay2').css({"display":"none"});
	      $('#jqxRealDlg_RealTimeRenamesCb').css({"display":"none"});
    }

    $('#jqxRealTimeSettingsDlg').jqxWindow('open');
}

////////////////Real-Time Settings dialog////////////////////////////
            
////////////////Files -> Deletions //////////////////////////


           

function ShowFoldersForDeletedFilesDlg()
{

    $('#jqxFoldersForDeletedFilesDlg').jqxWindow({ maxWidth: 710,  width: 710, maxHeight:480, height:480, autoOpen: false, isModal: true,
       theme: GTheme, animationType: 'slide', draggable: true });
                
    $("#inptMoveDeletedFilesIntoFolderL").jqxInput({ width : 580, height : 25});
    $("#inptMoveDeletedFilesIntoFolderL").jqxInput('val', GMoveDeletedFilesIntoFolderL);

    $("#inptMoveDeletedFilesIntoFolderR").jqxInput({ width : 580, height : 25});
    $("#inptMoveDeletedFilesIntoFolderR").jqxInput('val', GMoveDeletedFilesIntoFolderR);
               

    $("#btnDirSelectL").jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
    $('#btnDirSelectL').off('click');
    $('#btnDirSelectL').click(function () {
      InitDirTreeSelectForm($("#inptMoveDeletedFilesIntoFolderL"), null, "left");
    });

    $("#btnDirSelectR").jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
    $('#btnDirSelectR').off('click');
    $('#btnDirSelectR').click(function () {
      InitDirTreeSelectForm($("#inptMoveDeletedFilesIntoFolderR"), null, "right");
    });


    $('#Files_OK_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
    $('#Files_OK_btn').off('click');
    $('#Files_OK_btn').click(function () {
       GMoveDeletedFilesIntoFolderL = $("#inptMoveDeletedFilesIntoFolderL").jqxInput('val');
       GMoveDeletedFilesIntoFolderR = $("#inptMoveDeletedFilesIntoFolderR").jqxInput('val');
       $('#jqxFilesDeletions_MoveFilesToSFolder').jqxCheckBox('checked', ( GMoveDeletedFilesIntoFolderL != "" ) || ( GMoveDeletedFilesIntoFolderR != "" ) );
                            

       $('#jqxFoldersForDeletedFilesDlg').jqxWindow('close');
    });

    $('#Files_Cancel_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
    $('#Files_Cancel_btn').off('click');
    $('#Files_Cancel_btn').click(function () {

       $('#jqxFoldersForDeletedFilesDlg').jqxWindow('close');
    });





    $('#jqxFoldersForDeletedFilesDlg').jqxWindow('open');


}


/////////////////////////////////////////Tab Special


  function Show_Special_CacheDestinationFileListDlg( event )
  {
     if ($("#jqxSpecialSpFeatr_CacheDestinationFileListCb").jqxCheckBox( 'disabled')) return;

     $("#HTML_CacheDestinationFileListDlg_div").html( HTML_CacheDestinationFileListDlg );
     $('#jqxSpecial_CacheDestinationFileListDlg').jqxWindow({ maxWidth: 420,  width: 420, maxHeight:280, height:280, autoOpen: false, isModal: true,
      theme: GTheme, animationType: 'slide', draggable: true });
      

     $("#jqxSpecial_UseLocalDatabaseForCacheFileListCb").jqxCheckBox({ checked:  true });
     $("#jqxSpecial_DoubleCheckCacheHolesCb").jqxCheckBox({ checked:  GSpecial_DoubleCheckCacheHoles });

     $("#jqxSpecial_RefreshCacheEveryCb").jqxCheckBox({ checked:  GSpecial_RefreshCacheEvery > 0 });
     $("#jqxSpecial_RefreshCacheEveryCb").on( 'change', function (event) {

         if ($("#jqxSpecial_RefreshCacheEveryCb").jqxCheckBox('checked') == false )
         {
            $("#inptSpecial_RefreshCacheEvery").jqxNumberInput('val', 0 );
            $("#inptSpecial_RefreshCacheEvery").jqxNumberInput('disabled', true );
            $("#inptSpecial_CacheNotRefreshedCounter").jqxNumberInput('val', 0 );
            $("#inptSpecial_CacheNotRefreshedCounter").jqxNumberInput('disabled', true );
         }
         else
         {
            $("#inptSpecial_RefreshCacheEvery").jqxNumberInput('disabled', false );
            $("#inptSpecial_CacheNotRefreshedCounter").jqxNumberInput('disabled', false );
         }

      } );

     $("#inptSpecial_RefreshCacheEvery").jqxNumberInput({ width: 30, height: 25, inputMode: 'simple', decimalDigits: 0 });
     $("#inptSpecial_RefreshCacheEvery").jqxNumberInput('val', GSpecial_RefreshCacheEvery);
      
     $("#inptSpecial_CacheNotRefreshedCounter").jqxNumberInput({ width: 30, height: 25, inputMode: 'simple', decimalDigits: 0 });
     $("#inptSpecial_CacheNotRefreshedCounter").jqxNumberInput('val', GSpecial_CacheNotRefreshedCounter);
      

     $('#Special_CacheDestination_OK_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
     $('#Special_CacheDestination_OK_btn').off('click');
     $('#Special_CacheDestination_OK_btn').click(function () {
        
        GSpecial_CacheDestinationFileList = $("#jqxSpecial_UseLocalDatabaseForCacheFileListCb").jqxCheckBox( 'val' );
        GSpecial_DoubleCheckCacheHoles = $("#jqxSpecial_DoubleCheckCacheHolesCb").jqxCheckBox( 'checked' );
        GSpecial_RefreshCacheEvery = $("#inptSpecial_RefreshCacheEvery").jqxNumberInput('val');
        GSpecial_CacheNotRefreshedCounter = $("#inptSpecial_CacheNotRefreshedCounter").jqxNumberInput('val');
        $('#jqxSpecial_CacheDestinationFileListDlg').jqxWindow('close');
          
     });
      
     $('#Special_CacheDestination_Cancel_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
     $('#Special_CacheDestination_Cancel_btn').off('click');
     $('#Special_CacheDestination_Cancel_btn').click(function () {
         $('#jqxSpecial_CacheDestinationFileListDlg').jqxWindow('close');
     });
                    
     $('#jqxSpecial_CacheDestinationFileListDlg').on('close', function (event) {

            
           $("#jqxSpecialSpFeatr_CacheDestinationFileListCb").jqxCheckBox( 'val',  GSpecial_CacheDestinationFileList );
            
     });

     $('#jqxSpecial_CacheDestinationFileListDlg').jqxWindow('open');

  };

  ///////////////////////////////////////////////Bottom form buttons

  $('#Cancel_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
  $('#Cancel_btn').off('click');
  $('#Cancel_btn').click(function ()
     {
        $('#jqxProfileEditorForm').jqxWindow('close');
     });


  $('#OK_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
  $('#OK_btn').off('click');
  $('#OK_btn').click(function ()
  {
     if (bTabsEncryption &&
         ($("#jqxZippingEncrypt_Password").jqxPasswordInput('val') !=
          $("#jqxZippingEncrypt_Confirm").jqxPasswordInput('val')))
     {
        alert('ERROR: The password and confirmation fields on the Encryption tab sheet to not match.');
        return;
     }

     if ($("#inptProfileName").jqxInput('val')==="")
     {
        alert('ERROR: Profile Name Empty.');
        return;
     }

     if ($("#inptLeftHandSide").jqxInput('val')==="")
     {
        alert('ERROR: Left-Hand Side Path Empty.');
        return;
     }

     if ($("#inptRightHandSide").jqxInput('val')==="")
     {
        alert('ERROR: Right-Hand Side Path Empty.');
        return;
     }

    $('#OK_btn').jqxButton('disabled',true);
    $('#Cancel_btn').jqxButton('disabled',true);

    var CurrentProfile = $("#inptProfileName").jqxInput('val');
    GLeftStoredPath = $("#inptLeftHandSide").jqxInput( 'val' );
    GRightStoredPath =  $("#inptRightHandSide").jqxInput( 'val' );

    const wasRenamed=GLoadedProfile && (GLoadedProfile!="") && (CurrentProfile!=GLoadedProfile);

    GNewProfileName=CurrentProfile;

    if (wasRenamed)
       PostProfileEditor(CurrentProfile, GCurrentProfileAction, AskIfKeepBothProfiles);
    else
       PostProfileEditor(CurrentProfile, GCurrentProfileAction);
  });

  $('#jqxProfileEditorForm').on('close', function (event)
   {
     GProfileEditorFormOpen=false;
     //$('#jqxMainCategoryTabs').jqxTabs('destroy');
     $("#infoButton1").jqxWindow("destroy");
     destroyAllJQXWidgetsInside('#jqxProfileEditorForm');
     $('#jqxProfileEditorForm').jqxWindow('destroy');
     $('#jqxProfileEditorForm').remove();
     GProfileEditorInitialized=false;
   });

  MoreProfileEditorFormPreps();

  GLoadedProfile = $("#inptProfileName").jqxInput('val');
  $('#jqxProfileEditorForm').jqxWindow('open');
  GProfileEditorFormOpen=true;
 }
 catch(err)
 {
    showstatusmessage("Error: "+err);
    alert('Error initializing profile editor dialog: '+err);
 }

 $('#jqxLoader').jqxLoader('close');

 GProfileEditorInitialized=true;

 if (GisSyncoveryDebug) console.log("End of Profile Editor Init Big Func");
};

function MoreProfileEditorFormPreps()
{
  if (!GisSyncoveryWindows)
  {
    // $('#jqxScheduleRunUponWinLoginCb').css({"display":"none"});
    $('#jqxScheduleRunUponShutdownAndLogOutCb').css({"display":"none"});
    $('#jqxFilesMore_UseWindowsApi').css({"display":"none"});
    $('#jqxJob_RunAsUser').css({"display":"none"});
    $('#jqxFATakeAdminOwnershipCb').css({"display":"none"});
    $('#jqxJob_NetworkConnections').css({"display":"none"});
    $('#jqxJob_ShutdownLabel').css({"display":"none"});
    $('#jqxJob_WhenRunViaScheduler').css({"display":"none"});
    $('#jqxJob_WhenRunManuallyUnattended').css({"display":"none"});
    $('#jqxJob_WhenRunManuallyAttended').css({"display":"none"});
    $('#jqxJob_UseExternalCopyingTool').css({"display":"none"});
    $('#jqxJob_ShowCheckboxesInPreview').css({"display":"none"});
    $('#jqxFilesBypassFileBufferingLeftCb').css({"display":"none"});
    $('#jqxFilesBypassFileBufferingRightCb').css({"display":"none"});
    $('#BypassBufferingLabel').css({"display":"none"});

    $('#jqxComparStripReadOnlyAttrCb').css({"display":"none"});
    $('#jqxComparMoreDetectHardLinksCb').css({"display":"none"});

    $('#jqxMasks_ProcessReparsePointsCb').css({"display":"none"});
    $('#jqxMasks_FollowJunctionPointsFilesCb').css({"display":"none"});
    $('#jqxMasks_FollowJunctionPointsFoldersCb').css({"display":"none"});
    $('#jqxMasks_CopyOtherReparsePointsCb').css({"display":"none"});

    $('#inptSpecialSpFeatr_SetTargetVolumeLabel').css({"display":"none"});
    $('#lbSpecialSpFeatr_SetTargetVolumeLabel').css({"display":"none"});
  }

 GInternetProtocolSetLEFTRegistryList = [];
 GInternetProtocolSetRIGHTRegistryList = [];
 GInternetProtocolSetADDDESTRegistryList = [];
 GInternetProtocolSetLEFTRegistryList = deepCopy( GInternetProtocolSetRegistryList );
 GInternetProtocolSetRIGHTRegistryList = deepCopy( GInternetProtocolSetRegistryList );
 GInternetProtocolSetADDDESTRegistryList = deepCopy( GInternetProtocolSetRegistryList );
}

GFuncInitProfileEditorForm = InitProfileEditorForm;

